(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   4883097,      86012]
NotebookOptionsPosition[   4875829,      85907]
NotebookOutlinePosition[   4876263,      85924]
CellTagsIndexPosition[   4876220,      85921]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Sample playground", "Title",
 CellChangeTimes->{{3.8601397412505856`*^9, 
  3.860139755017807*^9}},ExpressionUUID->"d0e8ddea-97d3-4359-93ee-\
9734776dce2c"],

Cell[TextData[{
 "This notebook is used for the processing and fitting of one sample. It \
requires the functions in ",
 StyleBox["Polydisp fitting functions all data.nb",
  FontSlant->"Italic"],
 ".\nIntensity units are arbitrary as the patterns are rescaled for merging."
}], "Text",
 CellChangeTimes->{{3.8601397453382463`*^9, 3.8601397964528313`*^9}, {
  3.8617669288125243`*^9, 3.861766945139561*^9}, {3.8617673062268524`*^9, 
  3.8617673066939745`*^9}, {3.861942912912383*^9, 
  3.861942913146066*^9}},ExpressionUUID->"7c1a7862-4493-4bbd-ad86-\
2d905071e2e2"],

Cell[CellGroupData[{

Cell["Select and plot the data to be analyzed", "Subsubsection",
 CellChangeTimes->{{3.854421099868669*^9, 3.854421101948415*^9}, {
  3.8601398442554398`*^9, 
  3.8601398549474306`*^9}},ExpressionUUID->"44c23e06-c6ba-4d87-ae3e-\
52595994b93e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Join", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<C14_*\>\""}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<BG25_*\>\""}], "]"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"testsamples", "=", "%"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"testsamples", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<171_1.4002\>\"", ",", "\"\<171_30.9999\>\"", ",", 
       "\"\<171_9.99982\>\"", ",", "\"\<171_9.99999\>\""}], "}"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.843296948142498*^9, 3.843296958212912*^9}, {
   3.8432972784145517`*^9, 3.8432973057271643`*^9}, {3.8432977131560783`*^9, 
   3.843297716018899*^9}, {3.843298309901671*^9, 3.84329834918407*^9}, 
   3.843298997733918*^9, {3.8432990321174*^9, 3.843299072004407*^9}, {
   3.843299122424327*^9, 3.843299133661518*^9}, {3.843299265884342*^9, 
   3.84329926858108*^9}, {3.843300103749148*^9, 3.843300112466827*^9}, {
   3.8527849855621357`*^9, 3.852784994200242*^9}, {3.852787417047249*^9, 
   3.852787424091958*^9}, {3.8527874789702*^9, 3.8527874801375923`*^9}, {
   3.852787728214538*^9, 3.852787778738393*^9}, {3.8527968489630823`*^9, 
   3.8527968515622187`*^9}, {3.8527969362639837`*^9, 3.852796936383173*^9}, {
   3.8527970088774014`*^9, 3.8527970089163847`*^9}, {3.853836617160633*^9, 
   3.853836617592147*^9}, {3.854421141973649*^9, 3.854421142035899*^9}, {
   3.8544211928939333`*^9, 3.854421193010366*^9}, {3.860120705408345*^9, 
   3.860120705446088*^9}, {3.8617632879814606`*^9, 3.861763304765732*^9}, {
   3.8617673092767124`*^9, 3.8617673185406885`*^9}, {3.8859734491964083`*^9, 
   3.885973455500765*^9}, {3.8859747794365234`*^9, 3.8859748137649736`*^9}, {
   3.8859750181935196`*^9, 3.885975018432844*^9}, {3.8859763176629515`*^9, 
   3.8859763198468237`*^9}, {3.8859770271978893`*^9, 
   3.8859770297569485`*^9}, {3.8859774963407874`*^9, 3.885977500029621*^9}, {
   3.8859790256696296`*^9, 3.8859790880678005`*^9}, {3.8859792862203617`*^9, 
   3.885979303353922*^9}, {3.885979636059869*^9, 3.885979636325242*^9}, {
   3.8859798673963566`*^9, 3.885979867979951*^9}, {3.8859802087472224`*^9, 
   3.8859802091063414`*^9}, 3.8859802670443172`*^9, {3.8859805336112413`*^9, 
   3.8859805370509305`*^9}, {3.885980676883481*^9, 3.8859806770585265`*^9}, {
   3.8860615694895253`*^9, 3.8860615965610476`*^9}, {3.8902035063775234`*^9, 
   3.8902035070815973`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"288b6ba3-0e36-41d8-949e-a2c664f880eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C14_30.7138\"\>", ",", "\<\"C14_10.0042\"\>", 
   ",", "\<\"C14_1.504\"\>", ",", "\<\"BG25_30.7138\"\>", 
   ",", "\<\"BG25_10.0042\"\>", ",", "\<\"BG25_1.504\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.85278774182577*^9, 3.8527877823161783`*^9}, 
   3.852796852362589*^9, 3.852796937189692*^9, 3.852797010008708*^9, 
   3.8528624946560097`*^9, 3.853381366643115*^9, 3.853381473062273*^9, 
   3.8534022376061707`*^9, 3.85346909236896*^9, 3.8534962759553757`*^9, 
   3.8534996218158073`*^9, 3.853817842919454*^9, 3.853818242802884*^9, 
   3.853824682294836*^9, 3.853824869851644*^9, 3.853833074084684*^9, 
   3.853836452539434*^9, 3.8538366226871643`*^9, 3.8538385385329847`*^9, 
   3.854072553810278*^9, 3.85409167434895*^9, 3.854098459654634*^9, 
   3.854420757546021*^9, 3.854421148417843*^9, 3.8544211935109262`*^9, 
   3.8544236425084476`*^9, 3.860120714271991*^9, {3.8601208146323557`*^9, 
   3.860120817823097*^9}, 3.8601209904370317`*^9, {3.8601401966367846`*^9, 
   3.8601402016808*^9}, {3.8601411929801598`*^9, 3.860141197066132*^9}, 
   3.8617633119613857`*^9, 3.8617673196071157`*^9, 3.861941017862147*^9, 
   3.8619433170388165`*^9, 3.861950007077615*^9, 3.861950097594084*^9, 
   3.861950313053934*^9, 3.8859734561647086`*^9, 3.8859735723144336`*^9, {
   3.8859747343360167`*^9, 3.8859747430702314`*^9}, 3.8859747970713787`*^9, 
   3.8859750198706293`*^9, 3.885976323503401*^9, 3.8859770304553003`*^9, 
   3.885977536755321*^9, {3.885979057328891*^9, 3.885979092434539*^9}, {
   3.8859792905705223`*^9, 3.885979306593282*^9}, 3.8859796400840683`*^9, 
   3.885979871667265*^9, 3.8859802113912177`*^9, 3.8859802706713324`*^9, 
   3.885980540538966*^9, 3.8859806802452884`*^9, 3.886061601230296*^9, 
   3.8861522211573744`*^9, 3.8883109765610237`*^9, 3.8890022652170677`*^9, 
   3.8890603226490602`*^9, 3.88906456673145*^9, 3.889081912662714*^9, 
   3.88908274923429*^9, 3.889084479032218*^9, {3.8895035587135143`*^9, 
   3.8895035763897266`*^9}, 3.8895042359682283`*^9, 3.889668723612721*^9, 
   3.890203509837488*^9, 3.89020358352724*^9, 3.8909804837292213`*^9, 
   3.89098153769302*^9, 3.890982738443742*^9, 3.8914160072605443`*^9, 
   3.8926156550520883`*^9, 3.8926156938519573`*^9, 3.892628959324164*^9, 
   3.902314444197674*^9, 3.90522419570473*^9, {3.90790860294188*^9, 
   3.9079086057349777`*^9}, 3.907908660843829*^9, 3.9079088991409397`*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"948e2490-eb26-4925-a0bc-118d0f5dd682"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataToPlot", "=", 
   RowBox[{"scatteringDataSampleAveraged", "/@", "testsamples"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"plotDataRaw", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{"dataToPlot", ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", "testsamples"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"5", " ", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3"}]}]}], ",", 
         RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.01", ",", " ", "0.1", ",", " ", "1"}], "}"}], ",", 
        RowBox[{"{", "Automatic", "}"}], ",", " ", "None", ",", " ", "None"}],
        "}"}], ",", " ", 
      RowBox[{"FrameTicks", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
        "LogTicks", ",", "LinTicks", ",", " ", "None", ",", " ", "None"}], 
        "}"}]}]}], " ", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<DataRaw.pdf\>\""}], "}"}], "]"}], ",", "plotDataRaw"}], " ", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.84329809635746*^9, 3.843298105573452*^9}, {
   3.84329815837682*^9, 3.843298163080853*^9}, {3.843298211914578*^9, 
   3.8432982378108053`*^9}, {3.843298288845417*^9, 3.843298291452414*^9}, 
   3.843298361191868*^9, {3.84329871517915*^9, 3.843298719649724*^9}, {
   3.843299850907208*^9, 3.843299962957724*^9}, {3.843300008752656*^9, 
   3.8433000099440603`*^9}, {3.8433000666678867`*^9, 3.843300081842258*^9}, 
   3.8433001270605783`*^9, 3.852785029476323*^9, {3.8527875156086903`*^9, 
   3.852787529623748*^9}, {3.852787908039447*^9, 3.852787908637274*^9}, {
   3.88951548143122*^9, 3.88951548156557*^9}, {3.8896687353498526`*^9, 
   3.8896687417207317`*^9}, {3.8896725688232393`*^9, 3.889672590126113*^9}, {
   3.889672623190502*^9, 3.8896726983115826`*^9}, {3.889672740640524*^9, 
   3.889672758876796*^9}, {3.8896729834503565`*^9, 3.889673069010479*^9}, {
   3.889673142722207*^9, 3.8896731964734883`*^9}, {3.889676349237294*^9, 
   3.8896763709122796`*^9}, {3.889692253576544*^9, 3.889692254563936*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"6ebf2b6c-fd73-4115-90fc-264fde664a3f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3dcjt8bfvfb3ktJEw2jKKNwnqItRRFKJCOayC5SKi0loYE0vpWIMprq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         "]], 
        LineBox[{{-1.3930080352080074`, -5.298317366548036}, \
{-1.3925541015537621`, -2.8684808628768597`}, {-1.3919460401861279`, \
-2.554986877304766}, {-1.391338288426397, -1.468763069919728}, \
{-1.3907309656742075`, -1.1331208158640278`}, {-1.3901239517057393`, \
-1.9267423772403902`}, {-1.3895173657767712`, -4.355331416209375}, \
{-1.3889110878104278`, -2.654572905604933}, {-1.388696700756034, \
-5.298317366548036}}], 
        LineBox[{{-1.3878960158854576`, -5.298317366548036}, \
{-1.387699693172116, -2.9823887660510944`}, {-1.3870945755389497`, \
-2.973981403377814}, {-1.3864897642354097`, -1.4600837506264592`}, \
{-1.3858853185074895`, -0.9245771728632333}, {-1.3852813570020988`, \
-1.6764341084857146`}}], 
        LineBox[{{-1.382868795674771, -1.4176995495773308`}, \
{-1.382266534010283, -1.547813814022983}, {-1.3816646348465984`, \
-1.0869588931803011`}, {-1.3810630977476013`, -0.7179155554059655}, \
{-1.3804620407940025`, -0.14914891754090676`}, {-1.3798612264479944`, \
-3.3475520250394744`}}]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c81e8Xv9O91+VamdGUrIyQlu4tQiWRlJUkKSNRSQMlhWiQSEvfklBJ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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw8mnc81f8Xx+1Z4V6rREUZSaIvZeRQtCiKkspIS1aUSKkQlShEZUUyoqyQ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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c8lf8Xv3svW1RERkhIZd9LZSYkZURJSkmkIqlERltJKErFFylFiSie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         "]], 
        LineBox[CompressedData["
1:eJw9VXs81HkXJol1mfn9ZohqSYnaVjFha9uwNC7pjVxKF0XETrFZUVFEW2Fd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         "]], 
        LineBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAA1e6lA9s+L9TnJQbejEVwP7vBVJt
afi/KwexYvqTEMBuhDfZlGb4v4G41IfQEhHANWY/9Lxj+L+sTbaTXd0TwCiY
L37lYPi/6QwJmIU6EcDHspObDl74v9Oj2P5p8Q7AF/WKJzhb+L8tWq4rcxIR
wK8hlEZiWPi/VLcPJobEEMBCqtvTjFX4v/kp0z8iGhLAcYTT87dS+L9ro26C
/n4QwCJLtYHjT/i/xdbTyN3dDcDwL+ahD034v/XH368rDhDAgu2sLzxK+L9s
8ilfsAoTwE36YU9pR/i/kG1RpE0FFcBXJ1nclkT4v47sEZ/pjRLAyDje+sRB
+L/tYxK54HkQwKgMUobzPvi/orxxmXVxEcCjvfOiIjz4v/dhaL/Fuw/Aci0x
LFI5+L8dJs2vqwYOwAvWPEaCNvi/yn5AxbdUDsCRk5HMsjP4v9Ah3vg3ShHA
BEhV4+Mw+L8BEwbWHIATwK/AD2YVLvi/NlmOEQlEE8BVUNp4Ryv4vwJeC/x4
sxHAN6xJ93ko+L9O+LCJR7QQwIGgagWtJfi/lFwCVvRFEsBEwd5+4CL4v99e
iR6cixHAulymhxQg+L84SH4K5x0RwKDcb/tIHfi/ggzFBxPVD8DaGS/+fRr4
v7E38w/zPBDAvEqfa7MX+L9MRfarZx0VwGTbp2fpFPi/W0ml1bVpFMCvxRDO
HxL4v7pfJnm8MRHAS515al4P+L9TnJQbejEVwMkMGbo=
         "]], 
        LineBox[{{-1.5037373115477313`, -5.298317366548036}, \
{-1.5030652337220112`, -4.331103292784053}, {-1.5023861452440905`, \
-5.176982644281236}, {-1.5017074507178931`, -5.233671505510157}, \
{-1.501029283356703, -4.187777142744001}, {-1.500351508788963, \
-5.122999128780635}, {-1.49967426004908, -3.9248989701165513`}, \
{-1.4989974029491981`, -4.94981402959598}, {-1.4983210703453254`, \
-3.970192279352568}, {-1.4976451282328034`, -4.509504977213211}, \
{-1.497282419903845, -5.298317366548036}}], 
        LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAApneL4K/y979TnJQbejEVwHlwp7DS
8Pe/oCqk+TMhD8Dl+dtqD+73v0LfRKfBaxDAq/xFjUzr97+wKLB5IB4QwCSv
ajuK6Pe/iztDK8POEMAu5nZRyOX3v6NI1Xw7PxTA/88W4Qbj97/taga8RD0U
wBZq6vtF4Pe/1HrsTwxPE8DKMzF+hd33v3fKU7yUUg7A2R9Si8Xa97/4atrb
9LMPwFwUmf8F2Pe/arFhx2pfFMBr92D+RtX3v0BwMCS87hTAPA0CZIjS979q
SzeSOZEPwGg3y1PKz/e/hxvGkWfoDMCsDyGqDM33v8dW61hyCRXAQHtGik/K
978Vo+tpvI0RwNlgrNCSx/e/Z/RZdD4eEcBksYmg1sT3v6Zq+TaG0w3ACJhb
1hrC97/p9UiKYJYQwO8768mUwPe/U5yUG3oxFcBLt7NN
         "]], 
        LineBox[{{-1.483886653499008, -5.298317366548036}, \
{-1.4835555326370005`, -4.39705131516282}, {-1.4828895602005607`, \
-4.401750227067394}, {-1.482223965382512, -4.374087933670677}, \
{-1.4815588788483816`, -3.9384168175040464`}, {-1.4812637138944458`, \
-5.298317366548036}}], 
        LineBox[{{-1.4803310403373955`, -5.298317366548036}, \
{-1.4802299658562001`, -4.992724114168252}, {-1.480130607317852, \
-5.298317366548036}}], 
        LineBox[{{-1.4790167876091118`, -5.298317366548036}, \
{-1.4789028165302598`, -4.938134008965426}, {-1.478239869107999, \
-5.0622434804610075`}, {-1.4775774261954666`, -3.3915402251370703`}, \
{-1.4769153565646709`, -4.558825204390678}, {-1.4762537901952915`, \
-5.058448137319012}, {-1.4755925960345126`, -4.0385819735202935`}, \
{-1.4749775546448352`, -5.298317366548036}}], 
        LineBox[{{-1.4746371640347773`, -5.298317366548036}, \
{-1.4742715828886581`, -5.1823414383079065`}, {-1.4736117626649108`, \
-4.982317778518238}, {-1.4729523125165611`, -3.931031150665172}, \
{-1.4722933619135883`, -3.726149987245192}, {-1.4716347803258993`, \
-3.82044712941299}, {-1.4709766970544564`, -4.794451356971668}, \
{-1.470569512613433, -5.298317366548036}}], 
        LineBox[{{-1.4699900741939378`, -5.298317366548036}, \
{-1.4696617635223481`, -4.988863228633127}, {-1.4690049122101352`, \
-4.9862082416072315`}, {-1.4683990314453386`, -5.298317366548036}}], 
        LineBox[{{-1.4683340010489607`, -5.298317366548036}, \
{-1.467692567190646, -4.152511638544663}, {-1.467037072268365, \
-4.16446176460503}, {-1.4663819421636302`, -4.217548623597961}, \
{-1.4657273055057047`, -4.7324541834001455`}, {-1.465073032626457, \
-3.4151974642051353`}, {-1.4647478434084786`, -5.298317366548036}}], 
        LineBox[{{-1.4639294832167207`, -5.298317366548036}, \
{-1.4637658340941535`, -4.6625171875140605`}, {-1.4635861917095527`, \
-5.298317366548036}}], 
        LineBox[{{-1.4626413805310627`, -5.298317366548036}, \
{-1.4624603420993125`, -4.655187661493137}, {-1.4622737460920365`, \
-5.298317366548036}}], 
        LineBox[{{-1.4603921544184328`, -5.298317366548036}, \
{-1.4598544599396643`, -3.3016071198731365`}, {-1.459204016997299, \
-4.681394983523469}, {-1.458630550877732, -5.298317366548036}}], 
        LineBox[{{-1.4573737786764684`, -5.298317366548036}, \
{-1.4572553507560915`, -4.6081576337074575`}, {-1.4570061472398073`, \
-5.298317366548036}}], 
        LineBox[{{-1.4562430340056267`, -5.298317366548036}, \
{-1.455958325045854, -4.431771799698098}, {-1.4553104105673174`, \
-3.6884219517704806`}, {-1.4546629794324164`, -3.7875887872405443`}, \
{-1.454015903412415, -4.424856977366221}, {-1.4533693095687956`, \
-4.779929861161433}, {-1.4527230698400555`, -4.210198452513272}, \
{-1.4520773111248584`, -4.726138237648436}, {-1.4514319055284977`, \
-3.809659189144794}, {-1.4507869797872333`, -3.6576939636188914`}}], 
        LineBox[{{-1.4494595020042143`, -5.298317366548036}, \
{-1.4488545674843287`, -4.88190758788891}, {-1.4482113012607243`, \
-4.991634932671452}, {-1.4475683851914845`, -4.404280576219742}, \
{-1.446925945528132, -5.058222512174203}, {-1.4465574513315533`, \
-5.298317366548036}}], 
        LineBox[{{-1.4462147731221693`, -5.298317366548036}, \
{-1.445642239814265, -3.820915009826304}, {-1.4450009727872855`, \
-4.487892130493094}, {-1.4443601798882761`, -3.689620948818113}, \
{-1.4437197342142167`, -4.1859897494254525`}, {-1.4430797615355704`, \
-4.521661853962425}, {-1.4424401351130984`, -3.4512697536520935`}, \
{-1.4418009805577212`, -4.25023259330421}, {-1.4416042175553077`, \
-5.298317366548036}}], 
        LineBox[{{-1.4406928177346845`, -5.298317366548036}, \
{-1.4405238327723882`, -4.450565730070384}, {-1.4401712215799982`, \
-5.298317366548036}}], 
        LineBox[{{-1.4396163915314673`, -5.298317366548036}, \
{-1.4392483140132346`, -4.3610435177695415`}, {-1.438611132817861, \
-4.873463190028933}, {-1.4379744201298463`, -3.9908319487200803`}, \
{-1.437387973634555, -5.298317366548036}}], 
        LineBox[{{-1.4347967358750486`, -4.651005338914097}, \
{-1.434162446467272, -5.125227008565867}}], 
        LineBox[{{-1.4328950108984277`, -4.356067813256831}, \
{-1.4322618637985587`, -4.393001183791281}, {-1.4316291796892966`, \
-4.893982783803193}, {-1.4313152749202462`, -5.298317366548036}}], 
        LineBox[{{-1.429102314139286, -3.7975380561614918`}, \
{-1.428471563070626, -3.5806928834518836`}, {-1.428054099927964, \
-5.298317366548036}}], 
        LineBox[{{-1.427063380108268, -5.298317366548036}, \
{-1.4265817554936695`, -3.3967932259575795`}, {-1.42595265378466, \
-5.001251158093977}, {-1.4253238856188197`, -3.9803091493548735`}, \
{-1.424695574492021, -2.7125261171725916`}, {-1.4240675959930522`, \
-4.565336714721569}, {-1.423440073463934, -3.5096303820731847`}, \
{-1.4230640573350464`, -5.298317366548036}}], 
        LineBox[{{-1.4205899318224064`, -5.298317366548036}, \
{-1.4203081690295074`, -3.935636994726556}, {-1.4196830004606906`, \
-3.9113641821774228`}, {-1.4193428567564446`, -5.298317366548036}}], 
        LineBox[{{-1.4178097133274605`, -4.0750369361463985`}, \
{-1.4171861042786886`, -3.1460246966053}, {-1.4165628224394424`, \
-3.514548710088936}, {-1.4159399902365912`, -3.9104830761884}, \
{-1.4153650725124158`, -5.298317366548036}}], 
        LineBox[{{-1.4143543716746851`, -5.298317366548036}, \
{-1.414073695203434, -3.778047679104936}, {-1.4137264541023669`, \
-5.298317366548036}}], 
        LineBox[{{-1.4096183420134631`, -5.298317366548036}, \
{-1.4091139512378517`, -3.6865429357371795`}, {-1.408759986598989, \
-5.298317366548036}}], 
        LineBox[{{-1.4082412080315263`, -5.298317366548036}, \
{-1.407877849340566, -3.580615504897623}, {-1.40746819022165, \
-5.298317366548036}}], 
        LineBox[{{-1.4070536129033233`, -5.298317366548036}, \
{-1.406643273505007, -3.569438934928174}, {-1.4060265870799868`, \
-3.9277720571367136`}, {-1.4054102199677423`, -4.234246477078686}}], 
        LineBox[{{-1.403562249878592, -5.298317366548036}, \
{-1.4029486648038185`, -3.50232074803919}, {-1.4027706951203969`, \
-5.298317366548036}}], 
        LineBox[{{-1.400840577054237, -5.298317366548036}, \
{-1.4004931540181937`, -3.1121560601199656`}, {-1.3998802474910017`, \
-3.325239376225763}}], 
        LineBox[{{-1.398655499903949, -4.120282342546367}, \
{-1.398043657999477, -3.557972110479627}}], 
        LineBox[{{-1.3931625929004259`, -5.250416840132505}, \
{-1.3925541015537621`, -2.861298478622127}, {-1.3919460401861279`, \
-3.31801981184503}, {-1.391338288426397, -3.493553549565278}}], 
        LineBox[{{-1.3895173657767712`, -3.6246956952954177`}, \
{-1.3889110878104278`, -2.8870540138682053`}}], 
        LineBox[{{-1.4308119554125818`, -5.298317366548036}, \
{-1.4303649487833152`, -4.306568202162434}}]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWnc81e8Xt/e891pJkpE9olBkJBIZaZDxLRSJRImyQnZJWkhUFIpQRBnn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         "]], 
        LineBox[{{-0.274677743164378, -5.298317366548036}, \
{-0.27408705585431015`, -4.969485974757601}, {-0.273598930718067, \
-5.298317366548036}}], 
        LineBox[{{-0.2721308661865039, -5.298317366548036}, \
{-0.27164944546190495`, -5.099040171584874}, {-0.2710409310817236, \
-4.827102489230139}, {-0.27043278676611493`, -5.190183761590067}, \
{-0.27011722996158055`, -5.298317366548036}}], 
        LineBox[{{-0.2692932393090027, -5.298317366548036}, \
{-0.2692176845490116, -5.284095850375458}, {-0.268610647684061, \
-4.678386890519318}, {-0.26800405701359853`, -4.410781081388414}, \
{-0.2673977561952779, -4.831118370141682}, {-0.2671970924629547, \
-5.298317366548036}}], 
        LineBox[{{-0.2656315760385054, -5.298317366548036}, \
{-0.26558113396476035`, -5.285816629941033}, {-0.26497629994481253`, \
-4.720271339889647}, {-0.2643719091696942, -5.228139952607627}, \
{-0.26376780586728016`, -5.03739343249013}, {-0.26316406728534836`, \
-5.08188885025199}, {-0.262560770485036, -5.087528578106296}, \
{-0.26195775997776694`, -4.836499833344438}, {-0.26135511287304525`, \
-4.633771593023157}, {-0.26075290609440566`, -4.760675184375608}, \
{-0.26015098443578805`, -4.607324334564698}, {-0.2595494248689136, \
-4.364465508880019}, {-0.25894830418020226`, -3.4429375320786066`}}]}, {
        Hue[0.8503398874989481, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwcW3c8Vf8bt0cq4mqhpZCVFGU+9KVFEcrILKVsESmpNFFRRlZKIrOEklHn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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.487195066484062, -5.298317366548025}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.487195066484062, 
      1.6310721412512184`}, {-5.298317366548036, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"C14_30.7138\"", "\"C14_10.0042\"", "\"C14_1.504\"", 
       "\"BG25_30.7138\"", "\"BG25_10.0042\"", "\"BG25_1.504\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.528488, 0.470624, 0.701351]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.772079, 0.431554, 0.102387]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True", 
                 ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8926156992829533`*^9, 
   3.892628970650703*^9, 3.9023144534179716`*^9, 3.9079089080869436`*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"e5650256-6589-4793-8aa3-a5eae7c5ad0e"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\LH-ESRF-C14 - intensity\\\\DataRaw.pdf\"\>"], \
"Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8926156992829533`*^9, 
   3.892628970650703*^9, 3.9023144534179716`*^9, 3.9079089104766912`*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"d349b9b8-155d-4d73-b335-5b782981a53c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Process data", "Subsubsection",
 CellChangeTimes->{{3.8601399392765074`*^9, 3.8601399407209606`*^9}, {
   3.8859798317515917`*^9, 3.885979836205883*^9}, 
   3.8896895105228753`*^9},ExpressionUUID->"c68dbf72-8a8c-4c44-a3ef-\
9c60b7918969"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Subtract", " ", "backgrounds"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataToAnalyze", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
        RowBox[{
        "\"\<C14_30.7138\>\"", ",", "\"\<BG25_30.7138\>\"", ",", "1.0"}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{
         "\"\<C14_10.0042\>\"", ",", "\"\<BG25_10.0042\>\"", ",", "1.0"}], 
         "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"wat", " ", "doen", " ", "de", " ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4"}], "}"}]}], "}"}], "?", " ", "--"}]}], 
         ">", " ", 
         RowBox[{
         "vermenigvuldig", " ", "alle", " ", "intensity", " ", "waardes", " ",
           "met", " ", "4"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{"\"\<C14_1.504\>\"", ",", "\"\<BG25_1.504\>\"", ",", "1.0"}],
          "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotDataSubtracted", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"dataToAnalyze", ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<31 m\>\"", ",", " ", "\"\<10 m\>\"", ",", " ", "\"\<1.5 m\>\""}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "5"}]}], ",", 
           RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataSubtracted.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataSubtracted"}], " ", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.852787913735702*^9, 3.852788081126293*^9}, {
   3.852788124237091*^9, 3.852788221803185*^9}, {3.85278830511749*^9, 
   3.852788314820683*^9}, 3.852788353883409*^9, {3.8527951901832237`*^9, 
   3.852795266554426*^9}, {3.852795790301991*^9, 3.852795801188776*^9}, {
   3.8534052664208517`*^9, 3.853405359776355*^9}, 3.853405404221602*^9, {
   3.853409748113482*^9, 3.8534097682258587`*^9}, 3.853410243789892*^9, {
   3.853410568646674*^9, 3.853410593142272*^9}, {3.8538366552098618`*^9, 
   3.853836688425962*^9}, {3.8544213058580093`*^9, 3.8544213392155523`*^9}, {
   3.854421399974036*^9, 3.854421487835609*^9}, {3.860120980130918*^9, 
   3.8601209825914593`*^9}, {3.8601399447486825`*^9, 3.860139952932967*^9}, {
   3.861763386455724*^9, 3.8617634066433244`*^9}, {3.8617636721585855`*^9, 
   3.8617636911551275`*^9}, 3.861763753820904*^9, {3.861763829259494*^9, 
   3.8617638295877748`*^9}, {3.8617640171756115`*^9, 
   3.8617640685814066`*^9}, {3.861764108969255*^9, 3.8617641095314784`*^9}, {
   3.8617641469152203`*^9, 3.8617641470504246`*^9}, {3.8617642667147017`*^9, 
   3.861764269211673*^9}, {3.861764301965845*^9, 3.8617643679072943`*^9}, {
   3.861764616394006*^9, 3.861764629873103*^9}, {3.8617647074999027`*^9, 
   3.861764707889408*^9}, {3.861767331688716*^9, 3.8617674531915107`*^9}, {
   3.8619430250008717`*^9, 3.8619430252780623`*^9}, 3.885975125250722*^9, {
   3.885975162956421*^9, 3.8859751687928877`*^9}, {3.885975253564953*^9, 
   3.885975292171652*^9}, {3.8859753684038987`*^9, 3.8859753944654756`*^9}, {
   3.8859764080472107`*^9, 3.885976444462107*^9}, {3.8859766205505714`*^9, 
   3.885976701234559*^9}, {3.885977061431158*^9, 3.885977105613533*^9}, {
   3.8859775666625447`*^9, 3.8859775972455435`*^9}, {3.8859793109661627`*^9, 
   3.8859793451759176`*^9}, {3.8859793845178595`*^9, 
   3.8859794119426813`*^9}, {3.8859794524741387`*^9, 3.885979469919469*^9}, {
   3.8859796644128475`*^9, 3.8859797943053474`*^9}, {3.885979909660304*^9, 
   3.885979925707234*^9}, {3.885980058912956*^9, 3.8859800719340887`*^9}, {
   3.8859802956113253`*^9, 3.885980299515154*^9}, {3.8859803946280155`*^9, 
   3.8859804083447933`*^9}, {3.8859805548112154`*^9, 3.885980558763019*^9}, {
   3.8859806884189878`*^9, 3.8859807559686003`*^9}, {3.886061779883998*^9, 
   3.8860618911826696`*^9}, {3.886062270796764*^9, 3.8860623299442167`*^9}, {
   3.88606290416301*^9, 3.88606290438365*^9}, {3.886152279651626*^9, 
   3.8861523073398314`*^9}, {3.8861523706298904`*^9, 
   3.8861523714286704`*^9}, {3.888311253563958*^9, 3.8883112815379667`*^9}, {
   3.8895154757176466`*^9, 3.889515521326418*^9}, 3.889668778999714*^9, {
   3.8896725208785334`*^9, 3.889672555662263*^9}, {3.8896761687511916`*^9, 
   3.8896761875813046`*^9}, {3.8896762430656424`*^9, 3.8896763228575*^9}, {
   3.890203680281665*^9, 3.8902036879233007`*^9}, {3.890203721626855*^9, 
   3.8902037336503353`*^9}, {3.890203765562109*^9, 3.890203784550714*^9}, {
   3.890216653073305*^9, 3.89021672873991*^9}, {3.8902167682576685`*^9, 
   3.890216804044831*^9}, {3.89021744880861*^9, 3.890217482686234*^9}, {
   3.8902177558058324`*^9, 3.890217761492506*^9}, {3.8909816465407667`*^9, 
   3.890981653810565*^9}, {3.8909826260035453`*^9, 3.89098264917115*^9}, {
   3.890982718701262*^9, 3.890982720715917*^9}, {3.8926156599003186`*^9, 
   3.8926156619476256`*^9}, {3.9023144584508348`*^9, 3.9023144618548985`*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"5cc1674a-6b09-4f41-a48c-1487561a3f0f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3dcze8Xv7Pb3jspoenbIqPh+UiloSFStCQps2SFkBkZGS2hoTQohZSk
nkM7Te299x7a3X7399d9ndfznPM+7/cZ9/msO+pp7UYhkUhn2Uik//+eEX+s
wBkjDi7frZLlo2WJht3pTjYO4nDzzxmbYf+1hMTDY1KakuJwPr3RZNfJNUTN
wHlXwRYxCE55pyo1IkVIJcc+8YsWA5uJtp3RU1LEi/Lp9ZInxeCl/VlCd1yK
4BdhFD7SEgPlTkdd1xopwvZ2qtNTqhj0NtkpvL0rRXQ89f7VUy0K51IMralW
UoTikmPXoThR4J/hsNhKkyJ2bn38EF8VhYCsGq/MAUlCXdxAadRKFF7vjjye
USZJjFruH8tRFIXroSf33nkrSRiJHt0gQhEFDr4NbySvSBJhOdO3qltEYCw3
kNd6myTh5Uz/1vFdBJ71TobLUCQJ321awvIhInAhkeOGVKEE4Tn5Y03gBRHg
pdE9LZ5JEOkvLhEcB0Qg/cXzXjE7CeKhJE/WnS0iEKSye9RTR4KQf6u0dVxE
BNw3/kjaTJMgFsqMP+vNC8MTQ+ivaBQn/C2Pnz7aLAwZIbu/MRLEifSt9e/2
YWFwZxq4//MWJ2Qm9W6RYoVhzc1Xn6uMxInBkkNr3B4Kw875OyN0eXGiap2Y
9iVPYQjzP75QsyhGGB1+YalyUBhe5U1kKpeJEQaM2Ru+esKwul1Y6FuUGFE/
vnTi6EZh4EmV7hy4K0a0Du/fUccjDO/cJ/fpHBMj7Aw3+1fNCoGD2TafXjUx
QiP0jLtFhxD4qkhm3+ERIzbsMdffUyIEaWMGBi2tosTizw9N6WlCMLb2Jvv7
n6KE9XOp/WGRQnAtvMHW7Yko0bFjPU9/gBB41nQnffMUJbIdo1IjLglBi83a
+9LmokSNv75m1lEhaApKdYhXFSUGZLnTt1sKQfop9o1hNFFC7of1ayFdIUh5
fIZ41ydCHMx+esFYSQgyJ0fCyUUiBPWF8XK1qBCMT+3LV/zAOv98Qu0rTQgy
/HffXHtPhLhvekG6e0oQtp4z+ytwmnWfM57q0ikIt8dbdNWMRIgPBb36ypWC
0L1y97qCkggRQHJy1MWCUG2k8cObX4TwuJA6GvRJEK6SYhZr+oUJvk05WCNC
EOa68iIP5QkTSSd84vifCoJwrMv6XR+Fib9mmsFqNwTBg+/Ujp4XwoTAeePQ
x2cFQV72kOa3G8KERf6n8o3OguB5qcZQcJ8w0RX5ynvBUhB2u3OUimkIE0rO
u4rouwTBwmp5OVNCmNDcVLrDRFMQHAIUpPspwsTKabLG7/WCEJq17PlsSIhQ
K3ig6ikiCBVbahojSoWIHWH9vy0YggBRfSscsUJES2/ME+cFAdigxNOf9UaI
qFeZ2ho1LAAyCg7y1TeFiF9zovf42gSAzm9cLrFfiDAzctVOqhQArRzt7uO7
hQjlCzXKF3MF4PTs7U0fZYUIn1ftWifSBcDrrFbZfUkhovdPq6F/ogDwbJZr
yp0TJIKe3rIsfyMA643ZfSPqBYkMd5O9es8EQHLl8t/DuYJE2yd9i+o7AsDR
/Z069VGQ6Lu13iXwsgCsevxuDXwlSIw804nwOiUAA2I6yYMBgsSi0LT8JWcB
iOpc96XvtCBxePzkhsj9AtDxIenIN2sWHpvn76E9rHyb139QtRQkxJOWdtnp
CoCHveO/Pi1BYvnKs5Y+dQFovVEw6cAjSMxHNtUFbxSAFy2vz/uRBQnv5o/X
jkkKQLHJvqvbGwSIuvPpUtZ8ApDEPc/pUyNA7Gjay+NEE4BrTVw2/DkCxJhA
Sbz/Aj+w872c3RMkQHRRyg+Uj/HDyUQcui9UgFjuyr2o0cMPny9cpzk9ECBk
uXUvpjbyg8/DvcEXTggQ91QO/Dat4AdrDncQ2CtA9B1/ULmaxw9OVh1FmiYC
hJfXWaGKH/yg72kZyK0gQFgIzvF+T+WHq8+8JhsEBYgQ36CdP+L4YbvECdlz
K/yEW0nQxto3/HC989Fa3MNP7ItpMmV/yQ8L9b3Z0eX8xNSVH9v3P+QHve2n
2e984ScUTjf6frvJD/yHfEM1MviJlmSeBNVLLH8rrisTn/gJTw/CIuc0PzR+
VCk5F8xPHFi0Yjvmyg8Bd2wNYm7wE3Yx947KHOaHKer6dSUn+YnM+n28E1b8
cC3y7izJjOV/3zq6dg8/JEqG5Jpq8RNGR3ZkV+zkB7434/sttvITJzLU2dq0
+EFr4/a9TCl+ojE4X470Hz+YiTtI5/DwE5/z/mZpbeCHPLW1TbR2PmIk47Tv
DSl+6ItZ9+dILR/Btb9coEmQH14+Ourtl8JHlFwzUjHm5Ae/qpMR217yESFe
8leLyPzgfzn4e9spPmLLFxfXb1N8UEm6duKsCR/xgk+Id6WTD35dN7LvVeYj
kOTMAfcqPvh88+uHj6u8ROdjlDcNfOAzOMGM/sNL3Lp/ODc6lQ/eObw41VPH
S2TdPVniFcUHqaE+8jmYl6CfLTxw5BkfhDEzLYZTeQl5sa4OTz8+KJE/3q8T
xEtcz1OZiPDig1V6xLH+a7xE1Gsm2+gRPjju9TT1lAIvsWvxftKhfXxw90ry
BflRHoItIflkzy4+OPKz7XbZFA9xo5FS/liTD/Ti7X+dL+Ah/i4mulmvZ/lv
PtkWfoOHcN9hlLtFmI+1P0MrX17hIQ7q1JzdTOcDnZB/t51P8RBWYcuiFrO8
8MS77aq3Nw+x54uJ8d1+XrgwnHgidRMP8W8o4W1tAy88TKNvXC/OQ9T/p562
q4QXOL/e9i5hchPq+3hVirJ4wSU5bMv739yEE9U3xiOZFzqPutD33eEmEnYm
g1wkL1QN6TL7rnITI3q5CrPPeOGkW+TR7y7cRPNIzs2u27yQ9f758N3N3MT3
8vPn+i/wQgiSFmzi4CYKD16Lp7nzggSb8bErnVxERbJi+Y5DvFA/f1N5TzcX
0Wp28cF9M17guV3G+aCKi9jyTP7NkB4v3AjkdnLBXERlh0OKmzoLv0qPfSSR
iwjqbb8wJ8cL6qFWD3RvcRHuiQtRkSK8ULF+7NB1Wy5C4NXpQUd2XjCPvXKm
woGLOFtzgq65xAOpxhoabbJcRHO5f7LUGA/4rmvfXi7GRVTrZL6W7OQBmxHl
Quu/nESlgcEj1RoemLldY7U2lZPA9B/bbQt5YI2E6dGJWE7CyXzMJegHD/Cd
3nYQveEk/mplZvUm88CYgdNW6QhOQlO4UdIsmgdePjee2u7NSbCpXtiaF8QD
ekm/Ln1y5yS+vJKqsnrAA8yNKo3fT3ASIg+uf5q4xgMtO8ZyRzU4ieWTTi9j
PHngwwWTjGRpTqLb8oXhCVfW+UQyNXKCg9h6ZvbRLlseeM3YmZ8ywEGYdJxU
3WTGA7pu3559BJYdXvpPEfGAu9bF8IkvHMStq+Mft23mgbhrZ043veMgTgSF
Sdkp8MBcsIr5zfMcxHikD3+AFA84f79nmnGcgzjl+sW8jI8HMsJULzF2sPAm
v35dR2PxzTmmni7DQXByWjL857lhf1jMcD6Zg0i59ElsZYQbXi4yPKwn2Ykf
ayvS7nRyQ6MHjXBYYCeKDl1LkazjBtmDogEX29mJcRejxl8l3LCa9+dY/jd2
wrjPn3YFc8OZ0pSfnRHsxKOftjQijRuyjQveTh5mJz6nPkwSTeQG1hO19tc5
diLlXGLV8ltucIunfhY5xE7oh88aT73gBoub16tfGLAT1NojA7P+3GCzrSHb
ZRs78dM44zrndW74Yv7U5qEiO6GwoWdykzc3PFdS5i4aYxBb0LyQkzs3WOd+
nrDLZRCnx2/8fOvADVzPfIItGhnEvuLovOF93OBaYmtn9p1B+B/cyGa8hxva
AjhlWx8ziKxON/svutxQaOQ+0+jHIKJtD0Qqa3JDZPfD9qtXGISr7vnkVAVu
uHSrSzh4P4NoSat2MZDmhmGi6pKZKYPgiRF81SvIDcXk6Z3fZBjE5lob9SB2
bkhe+7uJIs0ghoxM6FZMLqCUfZjfw80gztp1jorPcMFg2IfXZR1sRCivZePY
IBfocItNGP1mI7x8r0VUtXOB/PE/Txt/shGNWgLSv2q5wMxrXcveZDYicOcW
rew/XBCe8DXy4ks2gif5ZmH+Ly6Qy1YsgCdshI4rObspgwvsSofU7t9gI7Zc
Ma9fSuaC0/u2vC2zYCMyavRllWK5oG5Q88ZOEzbC1MDo5NFwLkgk9/m6HWUj
bDI3hMU/Y/nHG9hMq7ARHqoiT+bvcwE1/uYOEXY2QjchfZPNdS5Yo8sd8Fqc
jUjU57XPPs8FUtLrisT/0oldJveW1U9ywTYnHt+0d3Riu33/v5QjXJCVY2p6
8ROdsAw/sknblguSZ42N2Z/QiRM91+5VmHPB/dwy5cQsOvFEbF2/pwEXPC2+
IsMfTicoR15uk9LhguMVr8OiHFnxn3k6VmlwgflEdJjkDjpx6/YH9EKRFS9k
o6CcIZ24eycw31GG5T/4eT/fTjrxsCCnbrMoiy8OORokSidWOlXshXlY+UeJ
fSoUpBNVB9borFK54HJV1Ymfa+iEnLC888wiJ+wqIqvvn6cRPOtUU6cnOeGv
8FV7/QQacUreXWxlgBMkwkZ/yX2jEbvXWt3g7+CEAwPlUSZPaUQh80v5f/Wc
oD1uceDGdRoRdTZm6kA5J1wVvvOk8gyNSBIzLbiXzwm+U8PvumxoxO1gsIKf
nNBnSDtQ4ksjLnAnn6WlcULjhzHXO/o04qivHpf1R06gi64KjPHSiPu3uwUS
33ECN+3gihAbjZjQ2n+WI5wT4se5bAOXqYQg523u88854TK/SERwD5Uwy3jf
0PuAE17dEGf4jlEJbaXN2MWPE/KcE7ZaTlCJAu/WpL7LrHwsBu6qtlGJyMKg
pxc8WffNl5+d+00l1K7d28flzgllyoOBo6Ws+zSx7g9OnKD0JuCA3Tcq0c8+
rL7/ICdovruecDaUSrx1b1GkWXACoyZLWcGSSiRYMr9nG7Lsm/tpnuepxPmD
rytu6nFCVZLNtgw3KvEtaIu9qRYnLEjpyy+bUonnhX6m0v+x8LI3vRTRpxIa
l049nt/ACcoR94eCdFnxpIT5W9Zwwu7n63I61lEJEZuyvEJhlh4tiTXNbFSi
R2hNeBY3J5R/2nDwTRmFEK1Jv5lB44SUs7/EQv5QiEt1d92yljlg6UnFdFs8
hXjv9FancIYD7Cfep0t+pRCGt/16m0Y4wDdjW+ZsFYUwLtM9M9vDAV+50m48
uE8hounv0iVaOUDNpvqifgKFaFL3+2JQywHtEuuIrlsUQiGvet/lMg6o0l2r
fcuSQqTP5d37nM8Bj9aVTD/dSiF2Scej6WyWnX/xuOVuClG+MOelm84BtiNk
hROSFCJIzpnryScOiBk9dG83H4UYcEgm9cZxAGe/BN8YB4XYSG7RN4jkgMKR
R8Xd/BTC7wh33odQVv7KT5eSK8lE+n/+l8SfccCodZHbp0Ey4TeQtffJAw6Q
L5LQ3tNHJvLMiB0ctzjA6v2no1w5ZMIrp0L18RUOOLhGwLk2lkyMF5jKinpz
QJjErkcBRWTiv1vppPiTHHDIaGeydwKZkBTTzd3pygEUab/sZ3fJxCsdRftW
ew6gv5HepHaOTDTFD2XdPsABjlVXpK87kgn6a5FGVXMOELYbfnjyFpnQdHCM
6zTkgFc9bpxmlmTW932o2OudLP0+BTytW0cmFuOzZO23cUCKVdygvCyZUHjV
8W2dOgeob7qx6xmdTFzc8A6PKXJAxIFssRNrWP5q4Sa/13FAIMnvsYgmmThd
HKb7RpIDZhtrmGZ9JGLYcfMTXyEOGDkwPCCyQCLOZkuru3JzQKl2C5fYBIlQ
+6wkaUXnAHMbMbm9CSTi7XMjYjeTHcxEHOz/XSARD9r8QnXn2OHFhUbn8z4k
gruRLKI7wQ6yMZrjYy9IhL4M36ddg+zwsvSvUt8dEhFmwmln3sUOiW6/y9O2
koi+h17szs3sEGiaXeRgSSKE9jalXaphBz2xKpKCHok40rBoHVTGDr1V1+p9
lEmE4VxkQ0YBO8jMR1Yf2k0iKkM+63Ridni667SXtRSJeHxOw5s/kx2ilNUE
GOIkoitd29vwCzsEi1i6a2WtoqE0sqbfR3ZQYTiMHV9ZRR/uVMdDLDtMnU44
MFu7in58Filhi2CHwzVpRq8DVxExZRhoHcoORNao+ZHYVWRSujAa84wdrj68
nC3ptoq8zNpaFh+yw8eP1mVLfquo+HOGte0ddoi3yPk9xL2KxFRcjDJ92aHv
IDN0apSJkvoVY2UvscOHO7N+lTqrSHz6uM8TT5ZeiUqWJl1MNCz4JGXVgx1u
fjV/K1PGROKaFcTloyy92rmt3iszkWXGpfUz9uxwRDbYaiSFiQxQl8UlG3bg
5x/9S1gxEZfdvR8rFuxgtLeCf5M4EwXqDTgGGLPDySJ6dtjEChIMjVdfo88O
zKt/oiznVlC21gXlrzqs/NVd/9a1rSDNGsHdllrsMHPjwYLG0gqSrbf3nlBl
h4C02f2zX1ZQFa9OaogiOzzmNLBTNllBX66kzOySY4fW6PdK0R4rqIzxZ9uU
FDukBtU0P3u9gjY5fzkXL8IOpM60+qatLDv6TbgLHztslhPR3ma6gtLUqz/I
crDDk+U/E1wKK8jkyufwHgo7fAu5vzi+bgXRMmKPJi8zYPv5X9hgdBkdwSpL
V2cZ8OM+tx2b4ApqKalzMJ9ggPPmV5xqhcvoDNrjt2GIAe9jtl/cHLiM4Jqa
E6mHAV5H4jSSriwj4xjr8Y5WBjQe+TqsV7OEuE7d3VRQz4DHozsslfSWUYJX
PS21ihUvgdhocXcZJVoP3Y34wwCy/sStiYIl9MNx4PXzfAbAll+TH6uX0PU3
vfoPMQMOWWWs88lfQq7p9PP3MhlQJ3VWxb93CbXCtY33vzIg4cBvOWb2Etoq
ELD/UTID7uDqvXltS0iW7/ZsUDwDMurPE00ji2iAkceIiWbAP6cbHwyVlpAp
Bft9e80A7cNLWW8DltD4i4nDpcEM8N9277rBtiX05HNPYH8gA6T01DcNkZdQ
+FMtCUYAA4ynPyd+WF5EcSceTSjfZUDTcYNgL+oSMvJ4w7f/BgPOX08+yShZ
RC/PbPK66cOyjb8/3da1iIymuLlTvRkg40FZMvBZRIda17T2nGZAcA7Tgd16
EWk7GrdKuzPgGB8txjh8ET3/9YDN3oUBZ/IFv/NILyI/mx7rN/YMyMxu13Qb
W0DXtc/+7LRh8dH0dn+Yv4AidhvpqVix9Dj/L0k0eQFdqgqr8DFlQOi2RgnN
8gV08lPEmRIDBtx2u9Dr1L+AHgy/EZBFDIieWfwofHMBtVsWJl3ZwYBTVzIt
KvwXkKPtT7P6zSz90yb7X7ouILz9V/t2VQZUhrwNfum9gLKLTV0jFBlAKXbU
it2xgCg3GisZ6xmw23Ip1uLiAqoyWpC7KM2ArD7qD3epBSR0fteBPjEGzM2f
OazbMY+aAw842wsyoDUwaUwhfB5ZmXTsrOFmAD3wloGU/zyi7307asVgwJGX
QXpNu+ZRjrzl8SoyA1ZcL5QpPJhHQZvyYmyW2eDHA6Z5aeQ8emBbG9U6ywZS
Zw+Uq1XPowsqx+1OTLLBE/iTy9g7j1xfHcufH2YD5dfGEgLMOWTUXdT1qI8N
vo3uYNtvMY/4/II/ynWyQdQu+twgzzySI9VLZjezwYTCRftE1XmkOBWjYl/H
Bu8VH5y3fDiHdhataVyuZIN7nzsHrQ7NoSvZp9a++8MG685VvU/SmkOFWXmz
pgVscEtQ07py/xzaqO/mOAdssJ9DmpZ4fA4pmQWZx2exQYnkahb90hzq3fzu
9+F0NjBM8r8haz6H6gJdUgQ+s0FGo5oJh9gckl80li39yAZ8pRbzjsxZdDlp
G3tAHMu2fHV287Y5tBz27qhZNBtkumUdGxSfQ3dfM1T437BBOE5JMYuZRTuP
jjo0hLDB0/sTU5H5swgOdk/HPGeDO0qbzwfALHL0vzXs/ZgNXLtpu98dmUWF
zzyQoT8bWOMh6ahjs2jKf9ew5G02kKt9pSTyYRbp92QPTfuyQWkaTw84zSLq
ydAdlZfZwIJ44x03+Q/JijyrTvFm4Vtfdm8QnEUyNO+0F2fYYGwy8XM88x9y
deVr8PFgA3VlcGjt+Ic+2+lrH3VlA9MZ37vOhrNoeGykzsKJDS6pcm58GfEP
SVMWEnceYtVnwePFl5f/0HcVuxSNA6z7CqfV/vP6h8RSqN0Klmxg9Nlr2OLG
P6RzfJlYZ8oGaxcPGPCf+IfyP5nmSxuywTjvPYdrdv/QJlvmKWmCDSSGt5AV
Nf4htceqGrI6bOBy9YTNwuIMulqwwC+/lQ38c07HUDn/oaff7zHUNNjg3fdz
87H/ZlCz7iq/ziY24F7n6NMn+g/xGoQrmSqwgd5PodwTeAZF5j43d5BjA9yp
kJ22bwY9jVW4ck6aDUjj+4i5mzNo/5fYhIfirP6NlLkg0DiD2APsGmKFWHxE
B4jP0qx8H76i5fKyQW6B10xn1QzaBHlKPRxsIFoeRkoKnkHyLXoG7HQ22Lzk
pzK9cwY1rPG0UiOx+P/0dR52m0G/dxWbHlqig9VK9yFwnUH813LV7s/SgYjb
OGE4OI0kDjcvfZukQ7C+U3ZWwDR6dFzkzcAIHR4Zxw3v85hGnr+pm9YO0CFl
gN/d8+Y0KpH6FHawm3X/0eGm0n/T6ODkh7bnbXQI91pwnyyfRhsbQhYrGukw
MDpMaKVPI80zwoP8tXQ4yL1hmvZ+GonvKY07UMk6d+AySpKcRrP9p9Vf/6GD
iB1/nUP3FLqa8uF2TwEdxCP/PMzMnUKiZShc/Tcdkvcm7qDrTyNnzZHzN7Pp
kLuBevLbf9Po+b2L3FXf6eATnaUolzKFkHD8kY1pdFi2mwz3K51C6wr2nfFN
oUP5O/tu4vMUEuHfq1b3gQ4x99/ulL4zhbT7z8VoxtHhXZfHxXOMabQ1Lbbg
eTQdLIZk69rLp1CU0Z/g6Td0eBCZOSMdN4WeFVXx2IXR4b2Berf2kym090ui
Cn5JBwezexfNlabQhhyTEcVAOvixIcMSnSnk0pK8NziADtIlXzf6dE8iD4V6
E9p9OnBcdBdwaJ1EE/V/Oi7eosPDc+Yp9txT6OiOUN4hXzqsW5fsnk+dQrYR
JpVHfOhAmQl8H6I9hXbYzMs1nafD3k93/lIGJtHKm2zqQU+WPiFs6q/2TiJG
+HfPmpOsfByn73RdnEQKZjzHbI6z+F/JXWE8mURpN3paG1zokGW/wcbl9iQq
KjzV5ORIh9p7WeVsPZPo7fnag/12dMhcs0cl4dgkYt6ws/I+QIfUg+w7/+Oc
RB2P1PNWLemw2znl6s6MCSRc/zYl0IwOd+p9reWbJ5CAai+f3B46/FIrSZ0Q
mUCdPZZd6fp0KEq+EiYROIHkS1U2WOykw/1dS2nbRCeRtsKfv/076CCRwZwT
+zKBPN/dHb6jRQewqQn/LjeJXEy+npLToMMR/iEj9p2T6PT1dKvcTXSIS8zZ
G5kygbRGJkOPK7L4N5uuPL45jqzul+3k3kCHitf55z7bTqDVi9/002TowLlV
N7xcegJxikpGO0nRQWNokrrffAIlDXjaconRgf3GqxpXyQkU81TN9Ycga15E
nt8LKRpHJjm1v07x0uGYlknY1tPjqFq720uGkw6ulQ1d72XHUeSfljO1dDpM
xm9rdc4dRw8fX014QqbDxCf/ZGGWPdM+ucN4hQYrwueXLCLGke2hJQH6Ag1u
n0wJJY6No8/XVFTzZmhQI6Yb6dwxhoRiJR/fm6BByrbQZH+vcXSF7KZkMkKD
JF/muskfY+jr4w9UvgEa8K5ytlcPjqLTpEDx+m4a7H4/ffdx9xjaWZXpFt1O
A8Wk3KIdyyOoY2PdwJlmGoznKU+q3BlFJypeROrW06A6M7BBLHUMRex6589T
TYMI5YoSUesx5PLoR0RHOQv/bOa+E+9HkaplcNe3EhrseB8nYec/iuKyxq2e
FNBAZ3Ou1d+6UbT9bkD/8d80eKyJqzrlR1FNo1Ksfg4NCumcpgLCoyjDNfiu
7A8aPAqYq9SrGEFG28Puk9Jp4Kxe55A9PIIWa0kJXZ9p0MllMtpxcwQdXxPd
V5DMiufobnLo4wgyNLQgkhNpwP+5Y/BrzzB629rxJfg9DW5YMtMk/wyj5Zwt
un7RNKhrKM5Hm0dQOrtS0+m3NCi9/qZqvcgIMpCICrB/RYPlIsKp0HoEJfjf
NNsbTINzet+zfl4eRsNrUiXRcxrcLUk+YuYxhGLLpGc3P6EB5Tu64i44gl5+
zWhWfkiDKn0fuzVHhpEFw6t4/T0aqMmpfrFh3Z+T0M1ee4sGO9PO7xALHULc
lsLfpK7ToL6UyXHyxDDSFp35JHmFhR/v/qNizxDa29uYIHWR5b/xkMeuf4NI
RrMwau05GmyXLrm9q3kIJZ+GoPVnaGB7Sjey7uUQWrdQelv5BA3W8FokMZSG
0KLSnMdmNxrsslWgOX4eRPraew13utDgvGbMF4l1Q6h8T4uImSMNwlVsDXX/
G0KPzX80HDpEg8uVqn95gwZRt/Tyo5M2NGgesNcufDWI1jr++O/6PhrE3kiL
kz47iHqv8f98bk6DDzaPnus4DqHcz2u0EkxokPzsvZF6xSDKmlsNAUMaSHzS
f27xYwANUdram3bRwPfFfqpk2gDSQK08c3o0sE+psdexGkDzxfIyIto02Hdy
irp0dACNn+4T0NpKAyvVssU31AH0wLC8/qAmDeZ95U2p/P3IWpD3wVVVGhz6
VeT1vKMPtW6wFY5SpoGgx0HS8wv9qCGv/WqhPA3cZhIdU1z7UWtpR+aEHA20
LM/ElQf2o3vvgyukZGiQeceLW0x3AN0jdH8YS9FAl2Zg0mw7gOqERHwui7Hm
afWZn+feATQi7MpIEKLBweU9211H+9H011PHm/ho0Dvk1y3wuB+trb/0kpeb
Bheuiuhvc+1DC7Xljw3YaVA84/xKKaYPlV4AK18aDZ7Pnz9s+LUPcXaEt34j
0eC6vXf3re99KC8+RWNymQoP8pVSj2n1IdUsazPVBSrIvdrpz/etFykfa1I8
848Kr9/eEs9y6EMt+pFFyZNUkACFOk8W/30my4oTo1TI+GY6XjrQizZkWBhv
GaKC9nvOySuavUhbZHbD1T4qVJ6RuBmS3ot8NA5k/+qigrHBtRPi/r0oRLKM
j6udCm71lntXX/WgUalCyYPNVBiOJt//8r4H7cv80PKungrTcg5tD0N70OqH
rv2T1VQ4Pvvl/fetvehuY/ONXZVUSOEptavZ3Y2yDtEdXpZSwfLf44nTBj2o
3KNysK+ICiEfYu/+zO9Guz1S5XXzqbB3LZk4ktGNuJskBV7+YvFp+z1/3aMH
xTv4xw9nU1nv8XP/iO4etCfec8DwBxVU2hgleTHdiHnP8m90OhUeS1/QDrrY
jeZrY11Xv1BBPch0M9doN8q4NR7ulMLiZ7xxYGNyN3K9/vkS/kiFWtuAwhtK
PUg49+y/dQlU6Ln6e+83hW6kZpkscj+WCtwH84xz1LpRwZp/tcNRVLj9mrHs
EtyFqHKVW/a/pQL1z3d+zV1dKHxvifrPV1RIYMwpKd7tQvo3zhXJh1BB4/TQ
zxlSF9ry0GbxxQsqkNffFnf50YmyNrHnkwKpYPb0xMyf/Z0IC0greD1i5f/2
iWREYhc6Uqgk0+lPBUdlu9zjJ7tQGM7/uP8uiy8uPazK1YnazQL+FPqx6nH2
y+0chU7U9krwut51Khy42nncd7oDbUxdykm7wvLvlPzxnb8L9ZzsCfzvEhWE
k+u4qk51oaEs3u54byrE7nhxPaaqCxWHtZet96TCi4KzrUJ3OhH1ceju6FNU
qDsbXSBm3IXsElr0ZT2oUJ27dfDg+05kVnCwJOoYFRjq80zz1A7EuJXSIOdC
hX2bRqK0VTrQgc0vTsc5UsHk+BYNDrcOdG/m412Vw1TIGmsg+og25BP8UebL
QZYePK5VkXmtKOztLl3t/Sw+SVCSEt2OevbINuZaUiGgYF3hwO0ORPJbmrHY
y+ov3k1+LnHtyLT9wdNmYyrkz7FbSvu3ounEm7EnDKng+S+V0RjdhhRLw7QW
dlEh82ZaXfHbNqRR/5QI2EkF/+kLKPtZG0pgSuet0aHC0wcWi8RiC4oToeHU
bVSwtss7XH++FdEek9SNtlDhr+b8f+Vu7SjoVI1IqzoVxCGfb/v2NnTWRt/z
4n9U4LN2yYqVaUNbb/Lq8ClTWfuuie2ydCvyTmVe/iDPqqeR0uWvQq2oDTVt
2LOeCt/oN6R0KlrQH/6TRK8MFSb80lpszFvRzWc+xXfXUGFgYqGA1tCE3n2t
ytkoQQUZcbWsF2ytKHZaX6ZIhDXvja71PbHNaOve14OnBKkQ72XuzNnUyPq+
/rhGgI8Ks+ENYbesGlHzZ4OMDC4qlH7eZLjWogk1K+t8d2anwkqgnFFXahOy
CnRdy0Fn5cPdV/xXqRGFEUEDX8lUaLx91CvdtwGdEXovcoRJgXcKqXYh65vR
TXPPWJ4lCtgUHq0pGWtCfDFlL3/OUaA2NtvK72o9erblTdfpGQqsu7XTMom7
AVk8/h64dpIC/53tD/5k24jE3pDDq0YpYDSckzWY2YBGf9iS7g9R4C/zss+d
I/Uo892bXzr9FCh5dip+zrkB0c5+bZnqpkDcnswt8RU1KC3Yz+pjBwXCwndz
8BTUo6qxQSm3Vgpk3pezfD9bj0wT6vRkmygwzzx4Qvp1PfptrPatpY4C++/W
Tv67V48cklr9wqspsPFosWnzaj0KoZRFHqqkQOmm2t2zag1oTekgv2QZBTbv
HnBOPlCLEhrWVTcXU+CMvBx7wrda1GtwrDeigAK2d1IFnn6uRlM+GrquuRSI
2DCg+zWkGtEOOQ8rAgXab/4XsOJdj9hjT/eP/6TAsbHqkYxztehpsLna90wK
3D60MDsmW4syP879upVOgfO/rr4ob69B6L1LxN6vFNiyNObS2luDjt28kyue
SoGTtC1o/GMtIl84qN6XRIGv5/hrE81r0L25mu60RApsGxyk/1SqRbSMxZa7
cRTgsH6R19xZgwxC8iQPxlBg9khopc/FOlSWrP5GMYoCTNNHgb+E6xCbyc4j
y28oMC7/vcFjTzUy7Bl1q3pFAbOEziM63yvRvPKupPgQCvAdE8O/NarRz3/a
mjdfUmB7+TnxR9uq0QPj9lnbZxTQuiATpcCoQfVWmxc0nlBAs+SquJ5DFSpz
1dvOE0CBMQ73h1l6VejcMu3r4H0KKE2z8W64XokaMl94FN6hgAGfIqlMrQq5
OE7YxvlRYK3/l108UIpGixT97l9n2Rs/HpjYU4XWruzpcL9KAe2AsJ9VPZUo
TMz+sullCti3P/nxYbYEmezzMlC9QIGRKOVkjV3lKHE5xEjoHAUWZ5b1Lnyr
RPx3230XzlDgwNRJjYUbJWjZ3b6v4yQFuIaNZeL/q0QeetK3i90p8EY/tGax
6w+STdpu+fUYBZTZiVDFoDIkfub33ggXCgRtOCU59LwElRhXXglwokAGXerg
ozV/UJDIldrL9hQItNB2nSXKkGR6jdNxOwokffovJPtUCUoUWxY+aEMBfbOG
tgdS5ShWnWPOyJpVX78DwVsOFaAhpihthyVLD54pj/muImR0f5fOpr0U4PWU
mVfyL0Hd5e9fy5qw6vNW720jFKOsbpcNokYUUPxXdDNKvRgJVgXVcO+mgPxX
obAr/Xlo7J3TRxpBgRAXszIZ7SIU4toRv6JLgajH9i6nWXi8krrFcztY/Wvk
vk7ivyIUURTEO72VAuRB+GQtk4f2n+K9PL6ZAkCc/bSlphg9ni0jj6pTQFR4
b+qT/hJ002Yhefg/ChzCUWq4vwCVemRcHVamQLHt1FGlpwWIk67uPqLAqnef
asYdgVz0u6vLY2wDBYZ/PeIwf5CHDnhbvphcR4FJu2JfJkcOCkiZbvi3ltU/
Fnr8+VcBZagv6SxJseY75mnsVUFAclde/CBLsOYxakm6/nEhejfXt59DlALh
wzY4TTQfEXQFhqAQBZ5dHz/PLvsDdXffqpbip4Dci++o4M9XNPFT4bs8D2uf
rWyQHhjNRAuRJmmanBQ413vR9879z8jjlkQhYlCg+i0OpvakIZUdJePmNAqM
Hnj4ePOab+jMrcD/HMks/uXLvJt2ZaPd/97ePMMkg+7JLZWDvhnIjU+l98YS
GWw5Vef3UNJQn+IZx+fzZODv5w7zuJyFJi6/7o/9R4bMmifPFPJ/opu8Y7cz
p8iw+ceCqtGnb2hj41vVinEy/Nfkdfzj+c8o/23PYO8IGRRNlCxcDX8i58Xl
ryuDZJgyNPLmC/uByl3lHov2k+GudnnghfXp6NWG5+fUe8jwJoPJ3dofgr7b
33c16ySD/J2nPW9uxaGjS8jFvY0MHzf/q8xw/IJaC5dP3G1m+cvc6F7WikFW
B5d93zWQoebbUOFo7Rf0kuvmq1+1ZPib9MsoMDENcUkV5HT+JYOPz+Duex1f
kM89oRFKJRnu947KDO7JQI1iH2Q3lpHB4vomFS25aIROltkbl5Bhzq04tmEu
Cn1p+/XmdCEZIj48aJQOjkGcUaVdz/PI8C6hBXHuP4nqozb/9/0XGQzfGS4s
arD8w/WuteeQ4dlyf+GmiiA0yKlZyvhJBnSYziiKjkKdWodkNDLJcPAfbXXq
dhK6s275vH06GVaCcl5p9Scij5Bjxfe/kiEPJ8e4+L9HVmtb135NJUPV5d1P
n1a/R8LUz+c7ksnAtXPiUs1qEAox31TI+5EMj/ZFp7Mve+GMvNfiOxPIsF+4
JS3sz31sPLLX/ex7MvyQaaukNwcjMu3pl8h3ZLD7+INfmi0O+bJ9WqiKJMPa
D4KySpfvY42EZR36WzJoHPkUueVJEDp1sMRnRzgZrEnNsS8p75DFVo+Us6Fk
SIiKbpDc7I/+rldsjw0ig9yn/OC9+0JxfqoDo+U5Gdj3iQ+kRLzEFi+d1goH
kmHozFRnUOB5bEW7qmX+mIXPndY6dDoaa5HZdvs/JEPR3lfDndyR+PCgrdHv
+2QQO906pnvmGhYoy9/JvEOG14KjBbdMv+Ivp+NUdG6Rwbt+3ZQr/RN+v20f
95UbZLjtv92SbWsm9jRb25FxjaXXkeBLgtURuND7eNycDytexmjrE8+3+P2G
O07bL5FBufa90N2vjtj2Tjnj6nky6J/9oCrW8A2H2MdE//QiQ7RSxsWa3AT8
Zr2jCuksGayc+Cg/XWOx3qJtrMEpMjzsCZCTj0jFlLgJrgAPMsy/7HSxjs/E
u4PuulS6kaGN7hqXupSKjRrOxYq5kmHNY2/qhMk3fEhZrMb5CBkKo++7Tn1M
w3N91eMJjmSwNKy0u0P9jgd42OemDpPhaUfc9vayZOy6S3hQz45Vv6rLz4aP
xuDN+YfyH9qQQcn4UwIXpOOW69qP6qzJEFBSuyDbn4rzxsW1N1iRofPuda76
jT+x/U67Km9zVv8Jf3IGDsC7VRysfpuSgTi+voVyIhffEnmYLmhMhrO6EwVi
HD9xzPxu6jFDMnAOneI00MzB06emtNL1ydD3J3l/S282joteNOcgyBBpsydr
Y+N3zH0819RRj4W3zyF3wDAD/16bpvJFmwwXtZ5JZiay+BRvmWBsJ4ODzL0L
XUY/8YGV5FAnLTIwHVdblmwwLu59sC5dk6XHrGP4rA5gVSO1J7zqrHr1HI8d
8s7FRZe4mtz/I0PDNuqzXI0sfOHYA8ZvZda+WOec2EsU4+5AARFpRdZ+0qrM
sezPx7XcQpQrG1n4tqKOb0SL8KFbC2W1cmQQvlLBqZqai7k3avpslmXxE6r+
VNuZi+1AmfRCmgz9o0FrhRdy8feP+9wmJcnwx9tlNMnxN14sF4nfJ06Gmb4I
X4W9efhWVF/eFxFWf5/74rPdtwAHbtiSIyxEBnvPCgmqRQH2Hzn74jI/GW6U
vA+RZy/CO0TZdzXzkGHBU2O71ZlcrGB2rhhxkWGfY9ZD+SNFuBqvUXnPztIv
j+Z5raME0zdfd+NiI0Oso5Myn3IuDmh65+lNJcNWt1c7rS8W42fHSg41kcjw
Ul8z3mehBHs5UaR2M0ngpjlx5vCuIiyXiL8kLZGgQIfy9rhxOfZKuiwrtkCC
ONn+n5RLRdj4YJTr7VkS/EwLHtnaUYQFJVOvjU2ToDy2nSp+rRCvjkt72E+S
wOfXWb+gA/nY5YCLYvEYCboXdxd4zRZg2p6prG0jJLgV65Wd8KIU+5mayMUP
kuC7/3F5Ts1iHObaflisnwQu4exRAg/+4ABxVbcHPST4d71nRZW7CF/ySiEW
O0mwtN7M+3xoOf401Tpyup0EIYdds+xMK7BE3JYTHS0kiDn8aExRuBwH8qt9
O9BEAvEHQri4sBJrbzWpLK4nQcnhRH7niQo8HraaiWpJEDHk5j5TUIxDt1Wc
S/9LggGFLxSL5Er86InW3H+VLPwprsFvXtV47nmqSVwZCZ5Me9+xtazGREaO
h8wfElC3tegWXq7C7kNt+18VkeD046V3PicrsdeLZ5zCBSQI7VI9E59TjvMC
9z8OzCVB7MGtu4IYVThSJ6GB6xcJ+JWHedQDKrG3O9/4gxwSOD4Yf+n7uRLv
c+CsYPtJgqH3Tv8dL6vEh5okfe5lkiD1xn9qZMu/WFY8d5CWQQLj/H2RCveq
8Jrf99bfSyOB0nZRH6GxSiy42LuB7QsJinjqnng9LMf3D7qP+qeQIOy6dtbS
pwq8seuJL2cyCThy/+6pe/sX75Bqq3rygQQ1WfJ8C4N/seh0y4hAAgk+q8kv
zt6vwU/L+MpC3pOAfatzVPHOauzit3xuTQwJbltLWB/ZXolrXVSq30WRwNv2
yE9xzyp8eXkNu3IECRpcctc+p9Zj9Ri3ic+vWfWn1OS0BlXj//ovftR+RYIW
g0LzLeQ6HJ40K54XQoI1nZqdV27+xc4/De0sglh6WIXnHFxfhR+fkzVpfM6q
b0Pg53eKNbi4q4rTLZAVP2e3lWdCDe4oVLk++ZjVH33Hjj60qsMir4/jGwEk
yJIhG31srMNzBz0+cz8gwdhocLyhfi1eO37Q+/U9Eiy+u+rkXlGDxfw3dSnf
IUGmXtG2gKka7Bq9LJPlR4JCgfUBTq51eNarlmvvDRL0aCUUJ5o24I9rvue1
XiNBsAHtwNqQeuxbVqDsdYUEGk8S3AWianGP64QD9TIrH3G+f2F36/GX3pM6
oRdIoC3Iob6rrhErUIR6VbxJoEw++Of3pnrcc1tT+5cnCeJ9GRkez+vx1OLL
Q7ZnWP0Zrdx2SK4RT7cFrR87SYKVrxa9TKdmHPxjNP2eBwkECyfqXp1twrVB
fDPSx1n6BDckqgvV4Ty26IV0VxJIyb0jy7nVY6Pn8glWLiz/tqSvO2UasOv4
lrXDTiS45El5/G13I46kHtO978DKN1T6xAmzBnweb10nd5gEIvkb9uWrN+AB
C7vkHFsSa9FyKXz91Yi3j+1YtbchgbtGhWq0YyPmWHo1t2BNgm3yWzetEajH
d/kb0sKsSDBq2q+5PNWIVePyxbZbkGDacHE34d+AVUtSdzaYkeD91z08den1
+ODsdc4rJiSwWX+az+95A/6OT7yS3EMC07JrbAyBJsz16FTpTwMSoGfPrpyI
aMIOGSe/OOuTYC96dKvtSiM2HNc9TCVIcHPV3pSe24i9Sv/FxuuRoOOQ/KZc
6SZ8+VFc6l4dEqzvvTkvutyElS5fdJrazqp/4m7VcctmnBd6tDRsKwm+OBxc
tvvQjE/9jWtGW1j1nRJ2lNdvwfa8Gh/6NUhwzZvTcLW2Bbun7ZV4psaa7+NB
282eNWNqRL3Rjv9IYN05G35GqglvjlYT7lZm7Zs5Nwfns80Yv1kX+USRVf/s
dol9f1vxo2zp4u3yJLBgvJiQvtyOPyy2p/SsZ82TfcaOJMdWnPFraMvzdST4
M8qhKnGkFY9uGby4U4YEmrd/3IKCNvxmxPPAyBoS6CmbVm6724Y7jSXGwiVZ
emYH+qXVtOOh2UcbTMVJwDgidNWAdb4/fp/IoggJRkIffc//14Ivsa1/90GI
BJzf1GxsytrwmMKVAXsBEkQZxoh0kdpxevTaEh4+Elw9/W8De0YLLlm+dgy4
SbDnmdzsS5EO7BJz5tV5ThLYaqCaRrN2vCbO7L4CO2u/ddXtW7OhHW9RpfG0
0ElAaHveWNXpxPx9babPqSSYrN/bIjrXjmujmtftIbP0dDsTwrPEyueEq9PS
yiqW35VnlaLXjnOFehNPLKziJ/HxxovOnfi8R8CRxplVTO6ZK71Q2Y6Vtr8y
Mp1YxbFqgXJriE5cY4JCfg6v4mefQ2q3KHZiNcNeIfX+VeyM49IGNnfgsK9h
C7Fdq/il/6NzyhUduH2oh0uqbRXvZ5pvzQnsxEuHMu6+aFzFTjtuNb6Kacei
LdmKXLWruG5bYvMB2U6cNpCvca9yFRNdjxlC9h14ICPyGKl0Ff8TKdXm1mjF
l0bmF30LWfmd7lw/Y9GJt03nZi7+XsW1f9n6OM078aefT5uu5Kxit6SXBYc7
O3Do7zNyi5mreMwyW/lpVAe+4VZRcu3bKtaiRuXx1XRgN9pQGDN1Ff96/2Ne
eLyT9f/DXXA7aRXff5lEDRnqxBtUAsXYE1ax4updGa/aDvziUnTB05hVLPtr
nstAqRPzKWaHiUay4nG4SP417MQ+ltIfIsNXcX7lOXsznW48YtMqqhyyimfk
KLcDNbqwEEdi7Lfnq7itJdm+tKgTix07+lj/ySqeUH318B7RhVdO1r2sfLCK
0yoOfX78vQsX7Sqadr67ikONWU9rnS78fXmj98TNVayXOfC87Eg3DuEI2nP7
2iqWTB9MKTvZjReOr9MWubyK+5nWCkRQN1Ye3X870XsVG8TM8X383YV9nO37
dp5dxVGSCZccXXvw5nWREbUnVvHdjTvnpH92Y0qw57kzbqvY18nq5HqWf2Cx
SCibyyoOOMk//Xachf+aUhflsIpb6ugWHAd78LveI8d17Vj10BWLKv3bje83
/uJt3L+KtXtPL05DN57W1WRctlzFs6FGdUG7unGDt6uoqNkqTi32y+uc7saj
ZgYX0o1W8eayhe1Og934yra4flt9Vn/Kx7U4H+7B3eqHExb1VvH5mDTToNQe
HB+473rEjlVcPhOgE9fYjXVfoYjdWqtYP8vnyhu2buxxQuvvoPoqdtxzZ2jY
rAc3fiqyer5pFas9z5jobe3ByxuVO3coruLp3VwWHix+n+h/f3SvX8U9m7J1
aBI9ONif//1TmVX82z7dZXh/D/Z/SNRrS61ileS7EydVu/GWyCrxAdFVvGaX
o+if/m7MdpocHSK4io8oGwXG6fbgnB9O24x4VzG96mFX1aVeXCjIKTTHsYpH
2JNbuz73YN39n5cS6KvYZHCiZN+pPvybbqfoQF7Fkec4dNbp9WCLpZIj/CtM
bDA4/OO2dx+uaJ1ozp9n4nN8soczvvbiUvNvLr4zTKwYy8jmbu7Bzpu7FLdM
MLFJdxJH99VeHNJya2FkmInreBs32Bn2Yvcnuzjj+5k4X7ywJp3aj1/ImK4/
2s3E7HEXtNWO9WFPq03X1rYz8fWV7AtzEn241lWtqbmJiVP8x3fynmDZyYWX
wuuYONL+uIjSl1689OOwxOG/TCzVlTIirdeLdV8S85LlTLzphub+qIe9OHlo
ubmlmImfvS29spGvD8uH/1mMzGdi4unDs1dE+7G5g4X0sV+s87XyhgPqfdiH
64CTUjYTj53+eu7mtT5czR3YMP6diZ/esHy/paQPZ/aXHchIY2KfuP4mDb4B
XOXLxuGXysRCN9MOB13px0/ZN+aYJDFx6sGINxkyffhdFPWDcAITS/QOZnZD
H3YRTQruiGFi04flG49e7ce5lS3pyZFM7B91fu8v5wG8IJJdd+01E7utNefk
vdKHbX6MK5uFMvFzt0K36/v6sdChTF+pl0wsa5Ebwtg1gPMto8mjT5k47aOP
3YBPP5b05LiDA1j4M4ajYo/6cUym49aX95nYNfUOXnDuxyKi0r3ut5k4t75m
KPhkLw7eE5and4Olv9xf0YMX+vBHlVMRwleZuBg3J/Xs7MfXXf7Ej1xk4tM+
NlaXM1n5R5z7kH+OidvGUS5PUj/GPj7NkWeY2ObWGLGxvg+POH2jXTvBxLSm
k2zn/QZw8oKCva0bE1/Y4ycY8Ksfp+/7nbDFhYlr71btu/OjH6/ROyEn5MjE
ORsUr375NIjvECovpuyY+MBevtnIJRafq383VR9gYpXvd/vfRA5i7dKHP9Os
mJhv7ONiNot/RQbpUuheJh6wvLci9G8A1zvdWH/NmInv3ToaHac+iH1w6IKz
Aave/L+Dq7T7sa906m9Dgonv5G2j5kQN4CBe/a+bdJm4InysYr3OAE5oKg0W
3s7iH1r539eEAbyxODViZTOT9S7t+xLYOoBfsj8M61dj4g0VRjBqP4TXJb3O
+KvCxAFiCmV/WHiJHyMLchSY2DvYWO688yBmrsLCx/VMHMEu1BgcPYiVzf9K
hcsw8QllHr/Vi8PY5VHvkYdSTLyz5Gv0qxtDeHR04OUVMSYmEV/WrrEdxLP3
agZOCjFx96Reb7jyACYWPis78jHxzTR75WnzQXz4kfMTKy4mDm5P89i/dRCP
bqO0GDCY+Ez7rSWr8SG846mTqTaViW+rpEvp/hrCR3LTYtRXV/CjXH66yb1h
fP1PipTi0gqWty48Idw0hEfmP1yXnVvBo5vUtLtfDeG47G0rEtMrOMg1IiZW
fhCrnyl1Ex5fwZeduu7lxQ5iPf7OIb7hFbz3rg5bCHMQv2pns+PuX8HmoWOh
4f2DuMI8vYCjewVv3nIsQ8NiGPOoWlixt6/gxfbhY0XJg3hnqz8wmlcw77pf
In9esPCM35iy169gu1FU4/VkEF884/yDo3oFhxXmyOSaDOLwjZP63BUrOLGj
ZW5JbwDrTqNUvj8rWCc6szXVcwhv/2atJVzIykdGQjXi5RC+basZIZG7grc7
quWmVQ1jal2ptCxewbqbI0T6pIfxvVOGfgpZK/i/HWVmvVrDeMb43LxaBgtP
L0ymumAIr219Yr3j6wp+GPbkUhhlCP95b/trd8oKvjScLHy0aRDLq8gLWH5k
2YnR+SV/h/BDy7cX7ONXMI/Vlvvrg4fx0ivV7x4xLH7V7uJP3UYw08ON93Lk
CtbrNixas34UyyqW7b7/egXrv/dpSz02iq8WNwSEhK5gpUMFMu5dI3jm9n+p
8S9XsM2YcUnOq2H8cnJjX2bgCvbVGnR+fWEYP1vyWyh9tILzrrFdHnMcwTyk
W2s6/VcwTTw/dmDjKP52jSk1e2cFm3yRptgQY7g+br0yt98KNvj0QpT9/ihu
utoltN53BXcO3NrlkDKClWTNuXR8VnDomut/8mNHsO302db9F1bwmVwPr8Lo
Efx9vf7PM14rOLNn9EUu3xiOtR2+8OD0ChacaAzUYPUzW8veHbEeKzg6yEr6
puIozvCPrYNjK3hD1vpWL7NRXNr880bbkRXcpy0wE5s8hG8WjDCXHVZwShrP
/yqw8ngq/yZqTYQitFuiXSi0atEihYQSKRQpVKQNrVrRjwpJZSllqUQKLdS5
opIk0qIUSSFlu3j2y/t9/7yfe59nZs6cM3PmHlq86x8OD28JH+tK6i1jf9Kh
7diRM6bNYp0El4Pz/oXs6kDTywlr3R0kOLlH+Z3Bpw7oGkbHHbOTYLHmGtZv
eCc+HK/9dmOlBNuMPPLWenfA0C+de7Vcgqen32THbO+A3HBvnXZLCapDzF42
Dm9HR9WbkcMXSpBvKZTs5DrRemDmyHnzJHi1wMz0PtWOU7Tf382zJDim5+Ex
5iOp/9v9ksiZElytYfxeLu1E7ZW+XXlGEsgHi2N5106cinLVbpgqQfmzPU1z
utrxLPZnitIkCVLX1N+KjO6AX3uKwWx9CWSzUkJ6xO2Y8/ZuqLeOBMmaXpal
LR24auP6JGYMiR9KvV/wpR3F82r54hESaAvnVnbP74SPtr+KeDjhe5zDuhFJ
7XhS2aKjP0yCLYaahkcK2lHbki69TpnUt3OcdaRUF1oCtzWdGSzBIAZj98l3
omXQldhCOQnmNtiYBbR1QLGveUmXFOG7w6GcOP8ufCn+hAkSAdoeYTPrtnYh
Qo2ft5EVEJ061uPytC5wFr3HY/sEFI3erfpEpgvznBeUvekW0MF6WHETuuC/
O/qLXIcAnvvu7uHcCXN925aFbQJaZunSu551YpCBlSikWYAJt+Fc5PIulKaU
x+X/FDC6ovDemvVdWPdNZCquF1BZf2HZcnTBJ9fzrXGdgF0hn09ZK3bhRl2m
ya7PAoylDFQjSX5/xE+i7tYIcL8kc2yhXjfGadx90P5OQAxUHhQ7diHhTuR7
owoBXe4X7WPsu6CoG/Y4sEzAjFb5xM7fXTj48lTCg1IBxaaqB582dkFr7veF
tEiAz6FpqpGRXch57fNt/lMBy6YV9q9x6MIT4yOLwx4LOHbfI9VWvQvv3/67
8ipfgJdH/cpS8v6MLRMKVe8LsNoeZ/auuAuH99VVOWcLyNJS0HAXurC2IOFO
ym0B3sl+Zp03u/H9Fxf6J53kv2KoJMapGwn/paqa3RCgo34oLHhkN5wej4g/
miLAsk85NORpJzYVqTW+uSpg//OWzWWe3ZgpLaszKkFAs8zNrFVnu+AR8Vhn
W5yAW0rBm6UJnuGmMeoF5wUYft7PyF3thnzi7lfyUQJaZWXe6XR0oX9Syk7n
CAHxmUmFM7kuLGc1P2acErD36ESj8OXdqFAdPJ0LE7DTfdS/KvK+DO70crsj
Av5znXLSRLsLRdtz7K6HCghOPnR5dEw3Vlnd0qT2CzC6WiqyorqxcOBghc0e
AfnjvX468V0Y8mrrktQAgpdK2VS/UtKfby7prL9AeFd1YmFkN3Jv3ipz2C4g
MWHXrs6sboxeZl5721vAVuUDtftJveYWPmlymwV4JiVUr+/pxiaN4BUemwRM
4h+USy3shtbICx+fuBK+zQzaFdrWBf23FrojnAW4BEEtMKgLz1r1nfc6ClDa
ckOt16YbLV9aVrxfTfg4ySDs5eMuCIfGGsywEWBuOPjDvZ/d+KkZUnh+hYC3
y7S+PjYSI+rJIYvupQJ6zHcP//yH4BvQe8BxsYCCulfvRiZ2Iz9+VWKehQDG
buXH4Ue6MaFxc+iIuQLqDx+PQksXWlXPLz5oLkDzWcWWHzN7EOv7Fg0zBKzo
lhp2fZAYEXpuE5cbCdgw+KK55p1uCHIrlt+ZKkAlfsgn9SFi5L18ukp9Eumn
wsU950u6kZP2UyFUX8BybfFDXV9S/5+3t3/qCMgL/hd0xVwM2emP5GzHEv7c
Ce7YIyVGvXva0oKRAoLy+ItfQkm/vJvm6GkSvYzD078p3Sj4uVk9Sk3A392V
RX6LxfjQd+I6qyLAbJ96S6SeGO+UJ2hsUxLwhu62GhwuhrzP0/kfBwlQPqqw
rGarGJyNhtUyWQGFP8w2xpzvxl7lh3J5Azz0dNVjNDLFqKl3STMQeCSvarnz
ybAbY1US2YsMj0jViqiOtd3gK3SMB/fxUP8ovE+8Lkaqw9URB7t5PFGr+efy
W4zNPy7/6GjnMcY9scBRvQcpx1vcvNp4fFLaVLo6RYy4ZL6gtpmHW1zv+bnd
YshIPyxZ3cTj/cbmmW2FYsxYcjjnRQMPhXU3TB8RfA82LLVd8I3Hm4jr3psX
ieGQt+FVfi2PHc1rft+aIgZb90Zs9JGHt9/GcJtvYqicruEzq3ksvlH4dvo4
MUxdz+fpV/J4+E1HIe1jN4a3TV2VUs5DeV3osgNrxVjg8il6zCsecyYdvTZy
oRiLszNyEkp4WKxe9DFPtQfmQc1HtEQ8+qdtDRzzQow15nFTLhbxmLhoZ02p
nxjd1crHNR7z+E/uhvfQsWJcCVyYH5dP8knNXD0Q14MX0y9f1LzPw3X+1rG+
Tr349IW2v5TNg90xbavnzR7YF9cXjLrD49liueQX9j3o26FJJ2aQeBf2LHLT
64HzCrMm3ZsEL4sPcWv+68H3E0EX0q7xmF/vf/J7hRgPe3pGTEsin7UvL1H8
1gMdlYCVuZd5FEgp3Ht3sgfrdx50nBPP49+5p0GGp3sx5lCTvCiGx0Dl2p59
xb2YVjbtvPU50h+na35qj3sw9vLM0uqzPOYGWLzPbBTD5qhvpVs4jy2TGx1Z
3R4knH8e1nySR3TJuHvXD/ZCNSBRKSiMxyXq3uuB0z1waxfm9x/mkcnOPZbp
0Aezd8ZLzobycPidUOj+WYyCmNVdIw/wkC37FzLSrgd602OCMvbwKFmwZnvF
RzGeFExKnBXIo1Rh9hP5fjF0fcwvv9zBw8NBMc5hei/Cv/EW6315+LZd6h03
ugf3r0c/aN3KY7zcldOnGDHSKi2rQreQ/BeeFi2V7cFfGy2oePD4fnZziYZs
L9wu73G67sZjbZNlnXJWL74PtX5s7sJDy9mlclxjD6acUi0tX8uD/pAfriLV
B6X3qSmeDjxuqKzMVCbxF6jF6tB2PA5nTzj9MqEXv25nBkSv4pHe1Dv3w4de
SNpPek1cwePphSRK/28PNjbWT8RSHs+/7PWhDXoRT/tFuSzmIT4aPOBn34vg
32+fiy149CmWOt8ieF8yeXclai4Ppymj8vvTe9G3Stpyyiwepvd0XfY39OB6
0cKIFzN5HJvh9brwZw/oEoWULcY8TowP7ZH72wvNupXOUoY8gkeMdbqd14uS
MXu+Jk/mYXmmZKkC+f5z44mBBRN4BH1f4Lw8qBcnZtR2fdfjYbXhavO+NeT5
OSeOH9HmEbNv5Z/P63qh1VPZoDOGx9nlyz5M6uuFjkPjt+IRJF/p6qtXtSn8
XS++6a3BY+yUdeNevu7Fiox5yoPVSH+maV2xudiLVrcfC7JUePzq/t026XMf
KgqMVB2UeDQGmHwKc+uDCzc3kxrEw+RN/gvR3D68ZTx+JMoSvpk1KI161ovm
yTcal0rxCJjaIIz91Qe7+j3H/gocFgyZcNKjog9p75+3xLIcIqyTx8gsomDx
Rv2fBcVh5ubUCw8iKLyqzEttFnOwHC90Ozf04j+1Vt0LnRxc87Ku6T3vgXzz
qvkW/ziozBEdM9nQi9X/ro9tbeVw79+oR4+TexFQnHQ57jeHMXaBL2vzKfwI
7f5m+ZPDVb5eOye6D0VdHoWd9Rwk44deSVPqg3ZRpEdyHYdnNyY3eGwh+P+w
Srar5SDvVGXaadyHxAiDVMkHDrs7GhXP+PUh75PS4uxqDh3nWwu22lDoiQlO
9ajkcLOus8ZuTx92/PVJVnvDwX5y9rhPJn0Y6rrUvfQVB9txvVlt4/vwctCo
hwdKOUw+KKk6kd+H8CnLaqYVc7g+XtYuf2Mf+K+NZ3485aD+LeLT7Sm9UBq9
YODiEw6jD8gNT1nYB+UfJ1VtH3IoGL5HTqG8D5DtaZDJ43BoZNO2uGG9MLUv
s35yj8M0b7+GI1V9KDsyfU/QXQ4/jxw+9deLxmbtfWbTbnMY1yh4b7xJ8Phe
UPArneTf/9Rnfl4fRLzzu+QbHPTHDNI9HtoH0ykbM12vcdDp+mxWca4Plist
RmgmcWjU0C6+9rUX68e0L6++TPpZZlb0/UQf5oykFKPjSb7yzhusbPoQNsYi
yiaWw8INQ7O7d1PoNXBJUzzP4f33MNGFoj7UzdU+VPYfh9YrhTqsAoXA93Na
zkRwGFXu+2lLFY3h0/yHWZ/moPjnRvEHgmf/hN1vB5/gYJpYmJJB9KK4TLKi
/CgHvu7jwrf2fRhc8m3df4c4HN6z7MwE8vu4fbm69iEcmKO56SfTKLxtdj2i
vp9D7vBb22dMoWBtvS3hUxCH8Q16UivT+2Di/XrZ1QDCh+wWY6fHFJbXSt31
3MGh9vTB2kI3BtEpqhkTfTn8WPM0Vb2Dglr1lo3tWzmE7Pvw5cVtGnGRQ2/k
beFAnb4alVRCYZ/v3puHPDjsatP4UGlMY/q1vFnLN3IQzZu3eY4ti50eOidU
XTnsmFKkt2w1g20/Wj1q13FoeKi2cverPqj12lOpjqSfD2o5IxcaOysuj91l
z6HE/ejcYCcaEX+XtMy1JfiGc/eu/u7DiS0P/Qat5HChnH9VQPAte7bucM1y
0s8Fsdbv4hkMGW1mfX0Jh/kReyYfd6ahUlt8PWARwe/fSsU1J2jENMg9WGjB
4WmN2/svJJ9Bmw47qs7l8Legw6z3HY22YXq36s05vJjkYt4zhMGDn8eicmZy
iHU777JAjsWikOOTw4wJv752XmhLonHc99UaJ0MOBt1lvuJvNCztJhhPnEKe
T33+TnEDjQOuq6+wE4g+OrNnX6qlsWbS4MK34zlMKJ+u75HAYPMRze2pOhxa
dLghw6xo3JM1LD8wlsQb80R8q5LoS07nkd0oDnTh/Yh/eTSKLeI2GGhxWO/h
8or35hAdFBDOq3N4N718zIP3NKzPWPnVDOWwxjBp1rNiCrtvq3y+o8whRuZd
PD2XQV7HKvqkIplXQVJlwt4+6DbKpLoPIviwbTWHV/QhsPrOwBxZks/kbraI
1D81aUPLcCkOjmM/vlocT+r7vi+sU2Bx+8i8oMfmFNLuj097w7IYWPsn9Hkc
hWtDHoVmUiy+vHM4fWk7hfOL/L+c6mExs+n17dglfdBPPvHHq4uFzN9/gauv
92F+ptXxJe0smhImNtUdoNA++t8bvTYW4qaCexoxFBD7Okm6hUU/45RQtYyF
zkoF3Z9NLD6ftA7+VUP01Ko0teQHC9sIf5el7TTcprc33fxO4ul41Eq/YOFZ
pj/hzFcWf3z/bm8qp7Bw0CNNv88sbL4usPu0g8GvKOMouw8sNpk8qcvNotFp
ffLBjGoWrv/ZlVJVLPTKbDy1KsnnNKpH2Y5FblJgIV/O4uPvi/dtbzNInZ2Q
2PiKhWFkvgIbRGPft6RpZaUs2r98oU6MZPCvfNbinGKCh9j2zlgvDsGKxjKX
nrGwqDdPdZzOYMpVm5VHC1kMW9qadnUsie+wcsH2Ryx+W7wY30F8QWmrkO+Q
z2KtvUvaS1Jn2mCNuvn3WbQ8mfw18jIL3ZF7Tk7MYVEzzlj6IMXgYeqjL2pZ
LNkfX7N2LyZ8yK69L8kkuB3VP1pzgQF9+oR+WxoLR5Fa+l4DBrfsNiz6nMpi
XsJ5WeM7LPw8t9eXprBwt7dMKmpk8OH+xMkPElnMiLE2lndnUa1/r/c6iYvp
T9zvD2JglbvL/0I8i9bsFypGzTT+Zf/nHRbL4tPfTi/NORzMTbYqBJ1nUdoZ
tcqX8Cile4ahVxSLq7kysUFkT2+etIhbG8nickEsm7uZxYu2jytXnGGh0fXV
lRopQedV0yXzTpL3eXEu3mSuqqTdK5wexuLngpfvDvymsSrp4He9IyxO/pk5
upLg/c1UOKp1kMX0TeZ+pptoyC9xLB8SzOL+Eb0rcqR+83u9cdL7WHR0dU7p
Jfi/vtk7iNnNYkxH6wvr+TRum9cyHbtYqGkkuVrUMFjeeP1Csz+LrzoVyz+z
NGwamm/Vbyd5Hno65FMiDQO1q9s/b2UxemXIow2KRA+lW9KrtrDoktdcYVlK
5s9K/chyDxaT7Ap1ux8zKKLO/SvdSPCWTbuzkMzBlItHe+FK8BjYL/gXMxhx
OC+00JlFwzQv/dB2BscYKu2hE4s5JTZ6/0ifnzuOtM9bQ/j+e0Hz2+s0tm19
n5hLeHl43+GD5zsYbPeS356zijxvcOvPWzLXDLHx890VLKY65FSlmzDwDH9V
kkV0xCeZ/Zzsz+DPh59OWZYsiiaLbXd0Mqg6leWZtZBFb7Clfastg6EeD4bd
nc8igYqwb3tE5pqC3ILsOSwUHuiHN10WEC1oK98zJzzcF60UdpOFV4rO+vsz
WRwJnKET3UDmgnHwsnxjwj93kVruOx6DRY53HxmyWJgUJDm4nse7jcMfFU1h
MbLCx9e0l0VYkXhB8UQWypFiE8tZxJeUWm19qc/ioMPz4VQWA8tSZ4UKXaIf
kxmLf1UySDrht+r9OBYZn26Fe8YyiP/xWeHLaDIvXLSnFi2jcOZc7dYfI4hu
Ii5jw2IOXd1VC1o1WCgZD60ITGYx4cG//C41sqds1aOeEZ0a3E3OYFVZVGh7
/X6WQfjN/Jggq8xit87YYeUKHPISUpaqKLLImfXskVof4eFgr68jBrFwHnfS
8XA6D30ls2H6smRO7D4qs23qAFbtvfXMSIpF5hbu2HGyt5bpPxsyX8Jg3t5N
Gdlkjxy1HFG9gmMwbsbToVd6OFx6d91sHc1A9+Yd1waKxvdFasO8ehmcf951
+OxHFunFyyJ2dzMoHa2qvbWZxSG5/pBjpO/NYb9XrU/l4ReoOvj8XwY3Z3e/
Y18JiG1ZrnKtlewZ7TGjFK5zyNHYnnPvN4PcF77X3l8lPljaqaz4J4MCZ3Hf
42k8jqcXHa5pYJAu1S40kDt22tQLt35/I3vD4aHhgXwOaV+DdzNfGLTeeD3a
/Ew/zot35gz5zOBLszQ7xkgCKd0hETofGOT47E/zbyO+I92l1rSawWjFlKzn
xHfqJjU9tyZ9u3w64dz0agkcrJ6Pd3/DwPjFsDRVQwnypu8dt7eM+JD4INcB
Mw6B4eOiIl8w2PnWN8SpR4Cap8ml688JD5Z6LWqczWNhTb3mYzA4a3ZWty9C
wJOgKKPqIgZ2mZZzN19iscPiUOEforvEd09PGxCf2OEg81PmIYPa5uR77S8F
GJ/eeWhsHgOX3vpPpx8JmH1R4d6sXAb7Nnu8ru8iPm6s4XqHbAbVPm8va96S
QPrwiEs77jBQM9B1srzNY7WG6arwTAbqKV62k8dwMOu6e/FmGgNhg3WOfgaH
5gkDTsWpDOacDNWymS+gJsT6dn0Kg01OdbvblASU3VXdIyQyqIvRLvyP8OqK
lU/N6CsMzm29+nwNy+N+ZmPa3EsMnq7+5SotFpA1PnyoaxyD4vMG1d/8eFzO
ZduCyVxjKq28qWAOsw+YbLoczeCk4o2FPAS4DHxZ/OQsg4l69JzBdzhMtW56
UhfO4Lvytdm3C8gdu0UhXXKKwRn7SfVBlQJ+zJg4SfcEg73Wdnd+5vLYsWTw
qKXHGPxQ8FkcTObDD59j13wOM7hrP58znUVjcaJ3QmQoqWfQo2fJ5A4O2SA/
POcAg9XdR55kJQnYMpA2/sNeBuurt9Cajf14kmKSyu5mcNt1a0s14Wnd2fUF
OgEMnNdtvcgMMDg6Q32e1f/38siXI0vVefR3yjvu9GUwe/6g1GMNPHadnP0l
zof4siNnM22VeZj7LOot8mJw+Na4LWVTeExOMD7y25PBJTvJWNOPDF7dj72q
6s5AqWTHWuUUDiP6IifNIT730YgAJ/MoKVGOXpzVFhcGkoIB19CHPJbcrqv5
bx2JpxD+Z+gIAbtP1vQ8dGTQ3Rb/Yo+PBONt8sOa7Ek/BrJblDb3o8u4+fpQ
O7In1eXrVAoFHG/PMrZY9X++nn9auIuHHbfZ3ncF0XvM2m8ygoD1k1y/xS9j
UD9sg/+VSNL/OfVcqSXRr9rcBq0D/chUdjzds5BB9oEbBuOm9ePG057U8RYM
7idoqXuM70fQ9BmGjsTHraw23PD0lwRDPllYHZ/F4L+/YqOVRlKiC7EXKu6b
MrgeIERd39QPOet1TU1k7ovyDPLzzxNdiob6aBox+BsdVBFWQ2Pdmq/BK6Yx
SJs4qkhmtwSzs1bSIZNJfmmz3+wjd37YNT/5uxNIf9u2as+9ICVaVlx/5Md4
gtdFR9V/RURvG9PPaOgyiM01NdxWwuHatwDeehyZP7/n2UY9EfB1lHH/4dEM
tK5vTTH/K6BoVYr/gxEMsPaH9rttLLzrMrb90WBQrtmU7p0mQc6LYZU66gze
mevPzNjTjzC1/OfOQxkcb62f8niYlGjBHl+9aGUGzxxnBbY846B0SVB5qchg
z2ZxlFhTSvTlp713P/ElL1obfI5CWhSZM8F6thwDjeYHVfdnk34P2XExUJpB
Q01mRpCtAAf5LwG3+2mw3W2dZfQAClZte/CLpzHTsuFrIblbQzNEJ3TI3v9w
fNGe/BApUZHnv6INZC7bTxZxZT085AaHH4/vIb7+AsyUNrEICcy4976LxqUK
Kb+SYAl+s3V+QztorJgWmlZSP4A7wvIo2780MnNPXCz/1A+DHL/5ka00dgzz
1y4dLS8yat7vUEZ8TcUv+Q/bXPox8E6rcVATDd2p37Q7Kvuh5dfGL/9B46t6
Tvh7CylRuemMI6e+05hW9GvnahL3i47j2Rdfabjs/wzhroCNGpcH5MndUT/a
fbxjrgB/2rPf6iMNb+MhLS+X9cNCRcY7nNwNUyvHZmS09WP77DdO5eQOklH/
5buRzIOsoXq3ld/SUKJltyw5zWPxQatI+3IaonNy4p5zPL54ZlXFvKIxZIOu
otRUAd65Edc+Ed9zWGqF/9MJsqLBCW6fRj8n9cZcWDLrnpRo3yi7ix6goW74
fvX8jn68Tmx5fLOIxvo67ckGxB8fWrJqW9tjUs9vyctNrf0wTFMKNXlIfLVT
nEz/exnROEULzQPkDvo3aAfKl8uIJKbHNJ/l0tgqH/w6UlaC6ov1SfI5NMpV
FccvqBgAqyV/1o74erVzZsVXzkkwya1z4OItGof0v97+4CrB8K3rv9Sn01jW
c+vnHZbsL43p8ybfJLq4lZQSNYjw8dCsgd3EZxUxc9+EbODxsXi9TVEyDUPv
DrOaGAEd0l78IOIDXx7/8XR97wC42yYzHS/TCHV2sLnhLqDrW3JFErmbqlx8
97Y9l6DVJbT9Tyzx5X1/Hs6N5qEz5+7uWRdIvmJ5x9XLpUVn45mDJ6JpWMn3
O8eQfh854vin6iyN+OiT2SssOUTtCvymHUGD/7DinfR4AbTr2pk7T9OYO3Ov
zvdPUqJbUzJVisid26vbmD7kQz9yc0NshoSR+u/X0qqTpURSdttU3Y7QGPhd
4xbvJSXyzIw0vXOQ3HWmPmp6RyUITNj/nQ+mcbfBed2vpVKitCtr/tjupxEW
3fJ+VbC0qF3uWkjyHhqm6b5lZselRVvGxft3BdJI3uL+a+hpadH359mNS3bR
eNhQ1GZbzGOcMPHxRX8aGbs3rF+zR0oUPCdA4892GicTOt383PvhObuqysKH
4LHLqkL+xACMpHKGXfCisXJk+DNLMi9GyXrm/vYkfLdNvOEwICWSa7H4OM+d
6GN0xY6rzjIi+RdprufdCL/P6k49XyotytB5YN/sQiNg5qM3gdsHoDk8qMzC
mdTTW158YMUAhkxaez3WieDz69730HBpUV1uvNC2hoZf1J0aE6Yfp6sKHi5Z
Tfi4pPLTqmAeTExz7xUboo8/Vd4FhRyyb2Rf6LEm+c4o808mfIyuMb9nS+72
s+eWJ/TvlhK9cxxmlL6URuBIzSOzJQPIeeI6XcqSxrG3P31/shy2Ps49u2Eh
jbgZEmZ4H4Xah5P988ndIXPllMm1ZCnRua++t4bNpVF9YMzdFX+kRNs2h27f
Qfbs9rv8uWuhhB8Nw06XmdLYUrgzRLJTWqS5Z5LBhBk09tavd9tzfAAmWsd0
jxvRMPkaUDXkk6xoT4ViUsM0Gn+GDcQsSRUQ2HnhwIIpNCZ1ur2Zkycl2hUg
VF+dSPq5OStA9EJG9FGiF8np03De4bRjZiyHt0fqil31aCiM8el+/XMACr3K
6x9rk3oadMu/qHB4aHHSfxS5W49qZVbMJ/7D8YbJ95BRNDpSCvf+/cNjvuLH
t1+1aDA11uv010qLjDj/MRYaNLQvpqvYa0vI/LjbkqRG9LTVb1/7LllRuUzK
MKmh5G7SNN1Wc1RKpFrX/nCLMo20M2srrsUwSGi8XfhCkYZnwa+QwNf9+Dk5
eMEUBRoh8e8vmSjKiOprdo+JkqNxKv2Ns3pcP0KGGx/olqbRkDF+sd9mWdEK
o89GzgMUVqy38J3ByYgyQymvQoHC+2jj/R32xL+4EelwFBbYtCa/I/wKd3og
c4amcLSqV05LdbDo1tehO9p7KZi9XmRk6CwnUsmwcVwrpjBpYZHFUNIP84U5
sYWdFCJLRXOdlvJIPZ/uoN9OIdrq3K5FN6REllNP+Z1to1BjmZr29IeU6IVF
1kBPC4WJ+wLUncN52DuFdm78TcEyonL2N3Vyt7Qsd3v5k8IEZcfxPetYNB8K
1jP5QWFqlK739hESPK/b5HXlOwW5y5uWR5I7Z3qw34BcHYWx+jIhHVESxAY2
aAXWUugKfeBTOk5GFDveIrzuIwW1xNSItFgBs9JVvVfUULhp0aW68byMaJ/3
1ycPqig0lbh9ztKXFpkoG/vrVlKYxda/Gp2tKHphbBof9YaC1KDU+zsnaork
nMNG82UUqgz83SfYS4vyj5iP8n1JQXpDU860alnRGem+wM8lJJ71pwPjdSTw
cqxeYlVM4arULetECznR+5jQnfnPCN5LyzQrTAYQmUurTSii4H+hes2iwH50
x8gOvfiYwofSWMMJJ1nMzLhySv4hwTusPu6s0f/n4vG1+/MoaFkGeA9upbDZ
8m5iSy6FR5bul+Y58Hir8dfCNYfCCTknzWmb5UQ15/Sd32RRqIxWfjOKVxA9
yJ/xasFtCjH7Y2b/7pIV3UsV37uXQSHvS7KUp7eMyFDaVqyfRuHFsZphkyOk
RUsjhmVdSqVwaHP4Nnviw5NPmTwdco3gPfircO2zoujJmr1Wx5IovOpTPTD/
MtF/5aeJfVcoFO4/MOVGOIsfMlpH/RIolI+b+1JqrKxIxnu20Y+LFI7Z+Ydl
b5ARfbvZsdY5loKhXsj8Qj05Ef3K5n3FeQqZScvy6l/Li3rMmZdLoykse3+t
QeGftGjHflX1wrMUrNdnDenq7odt9vQPMyMoKO013vlhNIWTTaH/bp+mMDex
KmuNlJQoTxJ5UP8keX7v9GOzH0uwIzTKMzGMxJu5frDnfDJvlFSKNI9S8Lkc
/iZ3Nwf9xKU7zx2i4BIvt6lHS0r0MSc3TjGU8DV+9rDGlwyWJF9VO/n//+26
jq8WjkuJdj89IDewl4KF19tnOsmyoorXcbahQRS8VxtbtfgJONLnrkQFUPj8
vWNe8Al5EeNqPC5oJwWNn9/ftncPEn0dsj2tw4/ks7Fd8jZbArmDO477b6cQ
opDzd+HMAVTfjPvQupXoMdxsjXQuB9mVqw/6eBG+fNJZV5kxgC6nlvhfnhTO
hZdcL9wpI7pf+XmQlzvhZ+bckyMk0qIvV7z+NroRPYaModZqCVgjp2Kw2ZXC
Ze2lieGyUiKtVpXqH84UhnwbXTT8kooooFJc7bmW5Nth1+v9Z5CIvvjXqtGB
gmfMCs2E0xLUCNFDt9gTfdafnRk/TFokmvZrfpMt0feMO2rDjBRFJ5wHzfJd
TmHUmK7b2/YrisJ2tHT+XULhYIj440AJCz67e2zAYgo7altXLdUTQ8+nIVG8
gIKd4vWqzpp+WE4x/cjNoeA0LVmNaR0muvLXOeroLAoGIWu5jYsNRN+PtF+S
MyP1Tp9xs6NOQRS0uVkjcgYFsdvwkoJyBVHl8NG/hhpTcH+99dWxjTQOdgVo
xhuSfu6QqR8f3w7eobhs7FTy/alNMVnvOaitKVaYr0thWvXQx7+zKXD17idK
xpH8fBm/2hJyF9vYeNqOoeD2y0DG2Lsb1knbkz+OJL9byihNZZthbeW7yUOL
5Dc74q39iBJMehux6c9wCnzKFLfXr5RE/wPp8EFL
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3k81O8T3133vUvIlRDlJgqh3dwqSnQ4k5QcUUon5Uj56hIqKpUkKqIk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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c81t8Xt0fIns9QhJYGERlHShRF0aBEJZVVSnyJQkMlGZEZoURGRGR+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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.487169751504421, -11.512925464970204`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.487169751504421, 
      1.630470845239991}, {-11.512925464970229`, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"31 m\"", "\"10 m\"", "\"1.5 m\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.892615668297901*^9, 3.892615708843791*^9, 3.892628990634544*^9, 
   3.9023144686465845`*^9, 3.9079089791747*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"b341ff52-2167-4468-bf1e-072c0e1821c1"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\LH-ESRF-C14 - intensity\\\\DataSubtracted.pdf\"\>"], \
"Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.892615668297901*^9, 3.892615708843791*^9, 3.892628990634544*^9, 
   3.9023144686465845`*^9, 3.907908981575495*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"e6ccec50-42ed-4632-9e20-749a6efd1d7a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Merge", " ", 
    RowBox[{"(", "relevant", ")"}], " ", "patterns"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Usually", " ", "we", " ", "only", " ", "merge", " ", "pattern", " ", "2",
      " ", "and", " ", "3"}], ",", " ", 
    RowBox[{
    "but", " ", "sometimes", " ", "we", " ", "also", " ", "use", " ", "1", 
     " ", "when", " ", "2", " ", "contains", " ", "a", " ", "weird", " ", 
     "kink", " ", "or", " ", "noise", " ", "etc"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "2", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "1", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Sequential", " ", "merging", " ", "of", " ", "first", " ", "pattern", 
     " ", "1"}], " ", "+", " ", 
    RowBox[{"2", " ", "and", " ", "then", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "2"}], ")"}]}], " ", "+", " ", "3"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"datamerged1", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.003", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.005", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.02", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.1", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{"datamerged1", ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.3"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.05", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "1"}], " ", "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "0.7"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{"datamerged1", ",", "\[IndentingNewLine]", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
     " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
       " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
       "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plotDataMerged", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamerged", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMerged.pdf\>\""}], "}"}], "]"}], ",", "plotDataMerged"}], 
    " ", "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Bin", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinned", "=", 
     RowBox[{"binData", "[", 
      RowBox[{"datamerged", ",", "0.05"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"default", ":", " ", "0.05"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotDataBinned", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamergedbinned", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMergedBinned.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataBinned"}], " ", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Export", " ", "merged", " ", "and", " ", "binned", " ", "data", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", "datamergedbinned", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS data merged and binned.csv\>\""}]}], 
       "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", "exportlist"}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.854423668689094*^9, 3.854423681960602*^9}, {
   3.8601210812169123`*^9, 3.8601211773702602`*^9}, {3.860121220142*^9, 
   3.860121220876803*^9}, {3.860121492525386*^9, 3.8601215079101877`*^9}, {
   3.860121718604267*^9, 3.8601217659879427`*^9}, {3.860121814486486*^9, 
   3.860121940090294*^9}, {3.860121990307417*^9, 3.860122029773138*^9}, {
   3.86012227550008*^9, 3.860122412026474*^9}, {3.860123590194846*^9, 
   3.8601236144362907`*^9}, 3.8601236508219957`*^9, {3.860139958454444*^9, 
   3.8601400142502003`*^9}, {3.8601409041122975`*^9, 
   3.8601409737863803`*^9}, {3.860141247131112*^9, 3.8601412486662936`*^9}, 
   3.860141363728487*^9, {3.861764464753133*^9, 3.8617644999883156`*^9}, {
   3.8617650690038815`*^9, 3.861765107161731*^9}, {3.8617654080879517`*^9, 
   3.8617654464808097`*^9}, {3.8617667857822647`*^9, 3.861766817572381*^9}, {
   3.861767478263466*^9, 3.8617674824174633`*^9}, {3.8617675156782837`*^9, 
   3.8617675385223627`*^9}, {3.861767600750394*^9, 3.8617678801582737`*^9}, {
   3.861768004639906*^9, 3.861768004842128*^9}, {3.8617680471976347`*^9, 
   3.8617680542883253`*^9}, 3.8617682512241673`*^9, {3.8619408859545107`*^9, 
   3.8619408879723635`*^9}, 3.8619500601432023`*^9, {3.8859755937637935`*^9, 
   3.8859756289602833`*^9}, {3.8859767824682684`*^9, 
   3.8859768072202587`*^9}, {3.885976912247283*^9, 3.885976915489427*^9}, {
   3.885977184321333*^9, 3.8859771875417037`*^9}, {3.8859772431391516`*^9, 
   3.8859772459190493`*^9}, {3.8859776946505795`*^9, 3.885977697414628*^9}, {
   3.885977754450777*^9, 3.8859777568929634`*^9}, {3.8859804425147095`*^9, 
   3.8859804438235583`*^9}, 3.8859804753994827`*^9, {3.8859807731997614`*^9, 
   3.885980782688805*^9}, 3.8860629984459877`*^9, {3.886063060466019*^9, 
   3.8860631273919067`*^9}, {3.886071125028043*^9, 3.8860711896934166`*^9}, {
   3.8860714254613867`*^9, 3.8860714550837*^9}, {3.8895154616447597`*^9, 
   3.8895154658794193`*^9}, {3.8896724114246473`*^9, 3.889672412507053*^9}, {
   3.889672471225835*^9, 3.8896725071452694`*^9}, {3.889674589350315*^9, 
   3.889674633174043*^9}, {3.889674670910601*^9, 3.889674765787591*^9}, {
   3.8896748131059356`*^9, 3.889674848516157*^9}, {3.8896748918371353`*^9, 
   3.8896749698660383`*^9}, {3.8896759808235216`*^9, 
   3.8896760211101522`*^9}, {3.8896760618397036`*^9, 3.889676134804789*^9}, {
   3.8896766120107994`*^9, 3.8896766124494815`*^9}, {3.889676755304323*^9, 
   3.889676755581999*^9}, {3.8902038545244083`*^9, 3.890203901273981*^9}, {
   3.890205930477414*^9, 3.8902059314228735`*^9}, {3.8902102550185256`*^9, 
   3.890210255342898*^9}, 3.8902167482021494`*^9, {3.8902168284956217`*^9, 
   3.89021682871568*^9}, {3.890216868216955*^9, 3.8902168763206763`*^9}, {
   3.8902172079856234`*^9, 3.8902172082346754`*^9}, {3.890981726002406*^9, 
   3.890981786213588*^9}, {3.8909822356137176`*^9, 3.8909822357713594`*^9}, {
   3.892615673703761*^9, 3.892615674832757*^9}, {3.9023149053181133`*^9, 
   3.9023149055465136`*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"5b3c3b75-f6f9-43b4-ae93-bf843c1633be"],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 69, 23, 17063142620130600614, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.890981702842042*^9, 3.8909818034555726`*^9, 
  3.890982236334239*^9, 3.8909827548676395`*^9, 3.8914161111745663`*^9, 
  3.892615674980629*^9, 3.8926157117844877`*^9, 3.8926289946460123`*^9, 
  3.902314475596919*^9, 3.9023149068324966`*^9, 3.9079089386477184`*^9, 
  3.9079089852506685`*^9},
 CellLabel->
  "During evaluation of \
In[68]:=",ExpressionUUID->"06243671-a7e4-47b7-95a2-eb7e227cefe2"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.004583333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwUWHc81e8Xv9O99t4kKhJllCY9nyTZq4xCS1mR0e5rRaU0KCNJqRCKUIqS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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-6.017352763725104, -5.308040375906846},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{{{-6.907755278982137, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {9.210340371976184, 
        FormBox[
         TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}, {{{{-6.907755278982137, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {9.210340371976184, 
        FormBox[
         TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.210340371976184, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.903487552536127, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.308952660644293`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.596634733096073`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {10.819778284410283`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.002099841204238`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.156250521031495`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.289781913656018`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {11.407564949312402`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {{{-5.298317366548036, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.005\"", ShowStringCharacters -> False], 
           0.005`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.050\"", ShowStringCharacters -> False], 
           0.05`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.500\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.017352763725104, -0.6940203524770587}, {-5.308040375906846, 
   6.957409804563477}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.8926156752561193`*^9, 
   3.8926157119871216`*^9, 3.8926289949553337`*^9, 3.9023144760150347`*^9, 
   3.902314907158556*^9, 3.9079089393413925`*^9, 3.9079089854267397`*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"337e2063-eed9-40da-bc82-8a31614f2e90"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwVV3k4lV8Xxb3Xnd3BPBUVIpUUEnpPokghQyMiSUlIGmRMGihREamMFSml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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-6.017346770647141, -5.340336596093475},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20000], 9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30000], 10.308952660644293`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40000], 10.596634733096073`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60000], 11.002099841204238`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70000], 11.156250521031495`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80000], 11.289781913656018`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90000], 11.407564949312402`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20000], 9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30000], 10.308952660644293`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40000], 10.596634733096073`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60000], 11.002099841204238`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70000], 11.156250521031495`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80000], 11.289781913656018`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90000], 11.407564949312402`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.017346770647141, -0.6941627035247665}, {-5.340336596093475, 
   6.957409804563477}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.8926156752561193`*^9, 
   3.8926157119871216`*^9, 3.8926289949553337`*^9, 3.9023144760150347`*^9, 
   3.902314907158556*^9, 3.9079089393413925`*^9, 3.9079089859357333`*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"d6deca89-1522-4002-89f5-239e20fe19cf"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\LH-ESRF-C14 - intensity\\\\DataMerged.pdf\"\>"], \
"Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.8926156752561193`*^9, 
   3.8926157119871216`*^9, 3.8926289949553337`*^9, 3.9023144760150347`*^9, 
   3.902314907158556*^9, 3.9079089393413925`*^9, 3.907908987655626*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"9c9f8c72-0544-4b9d-bc43-823e754e0903"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.777881903329149, 6.878726819268058}, {-5.777881903329149,
          6.9184577741757565`}}], 
        LineBox[{{-5.777881903329149, 
         6.9184577741757565`}, {-5.777881903329149, 6.956670316206544}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.483842181677217, 6.55349676658566}, {-5.483842181677217, 
         6.586144765484615}}], 
        LineBox[{{-5.483842181677217, 6.586144765484615}, {-5.483842181677217,
          6.617760485600308}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.380228407219979, 6.390559679891012}, {-5.380228407219979,
          6.417682506571226}}], 
        LineBox[{{-5.380228407219979, 6.417682506571226}, {-5.380228407219979,
          6.44408906986336}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.286352047426554, 6.253732997777246}, {-5.286352047426554,
          6.281073763888456}}], 
        LineBox[{{-5.286352047426554, 6.281073763888456}, {-5.286352047426554,
          6.3076868633511465`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.228332740694611, 6.163791597071153}, {-5.228332740694611,
          6.188399531059561}}], 
        LineBox[{{-5.228332740694611, 6.188399531059561}, {-5.228332740694611,
          6.212416429684072}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.1734965151745005`, 
         6.068923646345879}, {-5.1734965151745005`, 6.090711778917184}}], 
        LineBox[{{-5.1734965151745005`, 
         6.090711778917184}, {-5.1734965151745005`, 6.1120352939285265`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.121512103387059, 5.994727497639104}, {-5.121512103387059,
          6.016042515009739}}], 
        LineBox[{{-5.121512103387059, 6.016042515009739}, {-5.121512103387059,
          6.036912668211323}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.0720974097604925`, 
         5.906701642237373}, {-5.0720974097604925`, 5.928649522509385}}], 
        LineBox[{{-5.0720974097604925`, 
         5.928649522509385}, {-5.0720974097604925`, 5.950126020655823}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.025010372042255, 5.847753870085171}, {-5.025010372042255,
          5.863838576219642}}], 
        LineBox[{{-5.025010372042255, 5.863838576219642}, {-5.025010372042255,
          5.879668654789482}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.980041374477484, 5.763055340446589}, {-4.980041374477484,
          5.779985825108138}}], 
        LineBox[{{-4.980041374477484, 5.779985825108138}, {-4.980041374477484,
          5.796634434129114}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.92662358321994, 5.656592950985593}, {-4.92662358321994, 
         5.679655256926716}}], 
        LineBox[{{-4.92662358321994, 5.679655256926716}, {-4.92662358321994, 
         5.702197660535848}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.87574337247038, 5.575163644103877}, {-4.87574337247038, 
         5.59219970560415}}], 
        LineBox[{{-4.87574337247038, 5.59219970560415}, {-4.87574337247038, 
         5.608950394551151}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.827483513108963, 5.48781579400378}, {-4.827483513108963, 
         5.508425087484682}}], 
        LineBox[{{-4.827483513108963, 5.508425087484682}, {-4.827483513108963,
          5.528618200735277}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.77239942676781, 5.394756481981338}, {-4.77239942676781, 
         5.413829642084569}}], 
        LineBox[{{-4.77239942676781, 5.413829642084569}, {-4.77239942676781, 
         5.432545815005675}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.720192452293243, 5.302321713051443}, {-4.720192452293243,
          5.321422004089876}}], 
        LineBox[{{-4.720192452293243, 5.321422004089876}, {-4.720192452293243,
          5.340164301120824}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.670576785004793, 5.206366892014528}, {-4.670576785004793,
          5.22806972562423}}], 
        LineBox[{{-4.670576785004793, 5.22806972562423}, {-4.670576785004793, 
         5.249311534088339}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.623307322213241, 
         5.1321528854585985`}, {-4.623307322213241, 5.144809162357253}}], 
        LineBox[{{-4.623307322213241, 5.144809162357253}, {-4.623307322213241,
          5.157307257814031}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.578172095309458, 5.034956657658233}, {-4.578172095309458,
          5.050745719930849}}], 
        LineBox[{{-4.578172095309458, 5.050745719930849}, {-4.578172095309458,
          5.0662893577192145`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.528024063416046, 4.940316626750307}, {-4.528024063416046,
          4.960480112103796}}], 
        LineBox[{{-4.528024063416046, 4.960480112103796}, {-4.528024063416046,
          4.980245054103072}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.473567500947851, 4.836012077293325}, {-4.473567500947851,
          4.856216188230888}}], 
        LineBox[{{-4.473567500947851, 4.856216188230888}, {-4.473567500947851,
          4.876020164101331}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.4219245540939545`, 
         4.735906917638573}, {-4.4219245540939545`, 4.75258284764823}}], 
        LineBox[{{-4.4219245540939545`, 
         4.75258284764823}, {-4.4219245540939545`, 4.768985246173363}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.372818566555532, 4.649109389477674}, {-4.372818566555532,
          4.661077861417712}}], 
        LineBox[{{-4.372818566555532, 4.661077861417712}, {-4.372818566555532,
          4.672904781526578}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.326011954933506, 4.568223468833393}, {-4.326011954933506,
          4.579271027116369}}], 
        LineBox[{{-4.326011954933506, 4.579271027116369}, {-4.326011954933506,
          4.590197869259573}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.275892138786888, 4.459172766237821}, {-4.275892138786888,
          4.473753546825009}}], 
        LineBox[{{-4.275892138786888, 4.473753546825009}, {-4.275892138786888,
          4.4881247799560695`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.222951251037713, 4.356473190392281}, {-4.222951251037713,
          4.370603872879289}}], 
        LineBox[{{-4.222951251037713, 4.370603872879289}, {-4.222951251037713,
          4.384537658238916}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.172673294218139, 4.252815111277387}, {-4.172673294218139,
          4.269781901190199}}], 
        LineBox[{{-4.172673294218139, 4.269781901190199}, {-4.172673294218139,
          4.28646561535245}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.124803134014643, 4.165395026734142}, {-4.124803134014643,
          4.174359610739594}}], 
        LineBox[{{-4.124803134014643, 4.174359610739594}, {-4.124803134014643,
          4.183244544481459}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.074701219535939, 4.057479293653429}, {-4.074701219535939,
          4.07226928010167}}], 
        LineBox[{{-4.074701219535939, 4.07226928010167}, {-4.074701219535939, 
         4.086843707100068}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.026921534839552, 
         3.9654573128093507`}, {-4.026921534839552, 3.9768165361449364`}}], 
        LineBox[{{-4.026921534839552, 
         3.9768165361449364`}, {-4.026921534839552, 3.9880481754250634`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.9773780413268547`, 
         3.867201239847278}, {-3.9773780413268547`, 3.8796132558421497`}}], 
        LineBox[{{-3.9773780413268547`, 
         3.8796132558421497`}, {-3.9773780413268547`, 3.8918731005191587`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.9262371908045295`, 
         3.7700880851945224`}, {-3.9262371908045295`, 3.787144426066366}}], 
        LineBox[{{-3.9262371908045295`, 
         3.787144426066366}, {-3.9262371908045295`, 3.803914720265529}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.8776461425773476`, 
         3.665785130814023}, {-3.8776461425773476`, 3.6764286553000516`}}], 
        LineBox[{{-3.8776461425773476`, 
         3.6764286553000516`}, {-3.8776461425773476`, 3.686960087185884}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.827799486652153, 3.544783979948073}, {-3.827799486652153,
          3.5601804033253246`}}], 
        LineBox[{{-3.827799486652153, 
         3.5601804033253246`}, {-3.827799486652153, 3.575343366756121}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.7770410262852683`, 
         3.4464844760408786`}, {-3.7770410262852683`, 3.4563673283855905`}}], 
        LineBox[{{-3.7770410262852683`, 
         3.4563673283855905`}, {-3.7770410262852683`, 3.466153465007558}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.7255676492705025`, 
         3.333768178046292}, {-3.7255676492705025`, 3.34452137650881}}], 
        LineBox[{{-3.7255676492705025`, 
         3.34452137650881}, {-3.7255676492705025`, 3.3551601727928455`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.6766150586043187`, 
         3.2445125507473445`}, {-3.6766150586043187`, 3.2567095153320316`}}], 
        LineBox[{{-3.6766150586043187`, 
         3.2567095153320316`}, {-3.6766150586043187`, 3.2687595048215643`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.6271250750319357`, 
         3.1365924522624624`}, {-3.6271250750319357`, 3.147662858557783}}], 
        LineBox[{{-3.6271250750319357`, 
         3.147662858557783}, {-3.6271250750319357`, 3.1586120516130087`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.577239779380398, 
         3.0325212574274714`}, {-3.577239779380398, 3.042410579884443}}], 
        LineBox[{{-3.577239779380398, 3.042410579884443}, {-3.577239779380398,
          3.0522030605608346`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.5271719803333474`, 
         2.923669587441966}, {-3.5271719803333474`, 2.933922856972525}}], 
        LineBox[{{-3.5271719803333474`, 
         2.933922856972525}, {-3.5271719803333474`, 2.944072063055176}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.4770227859145613`, 
         2.8194606743388992`}, {-3.4770227859145613`, 2.8289695028440063`}}], 
        LineBox[{{-3.4770227859145613`, 
         2.8289695028440063`}, {-3.4770227859145613`, 2.838388764536525}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.4269594457071775`, 
         2.716416966054618}, {-3.4269594457071775`, 2.7281019574944008`}}], 
        LineBox[{{-3.4269594457071775`, 
         2.7281019574944008`}, {-3.4269594457071775`, 2.7396519854386248`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.377049578478242, 
         2.6071234635756237`}, {-3.377049578478242, 2.6180705560226616`}}], 
        LineBox[{{-3.377049578478242, 
         2.6180705560226616`}, {-3.377049578478242, 2.6288991061592815`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.327422124402821, 
         2.5014938567729668`}, {-3.327422124402821, 2.51011455089501}}], 
        LineBox[{{-3.327422124402821, 2.51011455089501}, {-3.327422124402821, 
         2.518661563384314}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.2761327623308096`, 
         2.4008059109208832`}, {-3.2761327623308096`, 2.411568215254365}}], 
        LineBox[{{-3.2761327623308096`, 
         2.411568215254365}, {-3.2761327623308096`, 2.4222159246050428`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.2254264836890396`, 
         2.287624433961096}, {-3.2254264836890396`, 2.2973063093590156`}}], 
        LineBox[{{-3.2254264836890396`, 
         2.2973063093590156`}, {-3.2254264836890396`, 2.306895344198164}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.17716826024446, 2.19094782690196}, {-3.17716826024446, 
         2.1993048372384356`}}], 
        LineBox[{{-3.17716826024446, 2.1993048372384356`}, {-3.17716826024446,
          2.2075925863699966`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.127705210497175, 2.078092959715192}, {-3.127705210497175,
          2.089174565489172}}], 
        LineBox[{{-3.127705210497175, 2.089174565489172}, {-3.127705210497175,
          2.1001347139889504`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.077261733718196, 
         1.9708729324895589`}, {-3.077261733718196, 1.9792310272765963`}}], 
        LineBox[{{-3.077261733718196, 
         1.9792310272765963`}, {-3.077261733718196, 1.9875198429565457`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.0276924518494375`, 
         1.8572364829597598`}, {-3.0276924518494375`, 1.8651504515910073`}}], 
        LineBox[{{-3.0276924518494375`, 
         1.8651504515910073`}, {-3.0276924518494375`, 1.8730022807706561`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.977298040136891, 
         1.7506029913817016`}, {-2.977298040136891, 1.7597751076397197`}}], 
        LineBox[{{-2.977298040136891, 
         1.7597751076397197`}, {-2.977298040136891, 1.7688638602232825`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.932588839908245, 
         1.6564890917128041`}, {-2.932588839908245, 1.665051362096523}}], 
        LineBox[{{-2.932588839908245, 1.665051362096523}, {-2.932588839908245,
          1.673540941961671}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.522480231534296, 0.720604967582006}, {-2.522480231534296,
          0.7656995770952001}}], 
        LineBox[{{-2.522480231534296, 
         0.7656995770952001}, {-2.522480231534296, 0.8088481050675193}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.380038563220422, 
         0.39879323899974956`}, {-2.380038563220422, 0.4390889490370415}}], 
        LineBox[{{-2.380038563220422, 
         0.4390889490370415}, {-2.380038563220422, 0.4778236151701993}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.2851211182798545`, 
         0.17272969664193336`}, {-2.2851211182798545`, 
         0.20965334557164986`}}], 
        LineBox[{{-2.2851211182798545`, 
         0.20965334557164986`}, {-2.2851211182798545`, 0.2452620472369691}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.226506167649257, 
         0.036077237182485754`}, {-2.226506167649257, 0.07052855485839256}}], 
        LineBox[{{-2.226506167649257, 
         0.07052855485839256}, {-2.226506167649257, 0.10383240142889456`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.1711381157832257`, -0.09835029616405125}, \
{-2.1711381157832257`, -0.06435250941459827}}], 
        LineBox[{{-2.1711381157832257`, -0.06435250941459827}, \
{-2.1711381157832257`, -0.03147266861571993}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.1186760185140363`, -0.2265330666634384}, \
{-2.1186760185140363`, -0.19366503800277377`}}], 
        LineBox[{{-2.1186760185140363`, -0.19366503800277377`}, \
{-2.1186760185140363`, -0.16184302726966732`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.0688299492905053`, -0.3512222145420803}, \
{-2.0688299492905053`, -0.3202012539463972}}], 
        LineBox[{{-2.0688299492905053`, -0.3202012539463972}, \
{-2.0688299492905053`, -0.29011371044856843`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.021351319690928, -0.4683116373812356}, \
{-2.021351319690928, -0.43900658034861145`}}], 
        LineBox[{{-2.021351319690928, -0.43900658034861145`}, \
{-2.021351319690928, -0.41053591577615045`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.976025406568619, -0.5821393959075106}, \
{-1.976025406568619, -0.5540323913504438}}], 
        LineBox[{{-1.976025406568619, -0.5540323913504438}, \
{-1.976025406568619, -0.526693840764367}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.9326653384575119`, -0.690056439133567}, \
{-1.9326653384575119`, -0.6627740047087505}}], 
        LineBox[{{-1.9326653384575119`, -0.6627740047087505}, \
{-1.9326653384575119`, -0.636216176247646}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.8810672419769725`, -0.8259161606537296}, \
{-1.8810672419769725`, -0.7954179270188315}}], 
        LineBox[{{-1.8810672419769725`, -0.7954179270188315}, \
{-1.8810672419769725`, -0.7658223733875608}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.8223707416388202`, -0.9788893713770673}, \
{-1.8223707416388202`, -0.9491629922191582}}], 
        LineBox[{{-1.8223707416388202`, -0.9491629922191582}, \
{-1.8223707416388202`, -0.9202948206447312}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.7758907745205157`, -1.0983526372476962`}, \
{-1.7758907745205157`, -1.0740330078300782`}}], 
        LineBox[{{-1.7758907745205157`, -1.0740330078300782`}, \
{-1.7758907745205157`, -1.0502908077043205`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.7316070609965282`, -1.2208753155952436`}, \
{-1.7316070609965282`, -1.1928738536970798`}}], 
        LineBox[{{-1.7316070609965282`, -1.1928738536970798`}, \
{-1.7316070609965282`, -1.1656351634267907`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.680857774871063, -1.3574115343233186`}, \
{-1.680857774871063, -1.3314510690829922`}}], 
        LineBox[{{-1.680857774871063, -1.3314510690829922`}, \
{-1.680857774871063, -1.3061475314124875`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.632560487956873, -1.4909633613263018`}, \
{-1.632560487956873, -1.4653508542608025`}}], 
        LineBox[{{-1.632560487956873, -1.4653508542608025`}, \
{-1.632560487956873, -1.4403779987273646`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.5790774413137347`, -1.64356276485336}, \
{-1.5790774413137347`, -1.6161503653993559`}}], 
        LineBox[{{-1.5790774413137347`, -1.6161503653993559`}, \
{-1.5790774413137347`, -1.5894693998105025`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.5281875999704038`, -1.7852190095467984`}, \
{-1.5281875999704038`, -1.7607599166447272`}}], 
        LineBox[{{-1.5281875999704038`, -1.7607599166447272`}, \
{-1.5281875999704038`, -1.7368848154784444`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.4798745637368198`, -1.9269494331280526`}, \
{-1.4798745637368198`, -1.9015118745260273`}}], 
        LineBox[{{-1.4798745637368198`, -1.9015118745260273`}, \
{-1.4798745637368198`, -1.8767053661179152`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.4273150021222818`, -2.082211703888827}, \
{-1.4273150021222818`, -2.0569913541136855`}}], 
        LineBox[{{-1.4273150021222818`, -2.0569913541136855`}, \
{-1.4273150021222818`, -2.032391454488731}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.377381030775886, -2.2298354303326553`}, \
{-1.377381030775886, -2.2063649221245973`}}], 
        LineBox[{{-1.377381030775886, -2.2063649221245973`}, \
{-1.377381030775886, -2.1834326696773707`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.329822772449285, -2.373372950624341}, \
{-1.329822772449285, -2.350572671960546}}], 
        LineBox[{{-1.329822772449285, -2.350572671960546}, \
{-1.329822772449285, -2.3282806784879257`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.2789374525299622`, -2.53087880297484}, \
{-1.2789374525299622`, -2.5062271583177056`}}], 
        LineBox[{{-1.2789374525299622`, -2.5062271583177056`}, \
{-1.2789374525299622`, -2.482168625378371}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.2252283792125176`, -2.6995894833957337`}, \
{-1.2252283792125176`, -2.6759005149006745`}}], 
        LineBox[{{-1.2252283792125176`, -2.6759005149006745`}, \
{-1.2252283792125176`, -2.652759752245413}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.1742581157840541`, -2.8598353774055916`}, \
{-1.1742581157840541`, -2.837518507528072}}], 
        LineBox[{{-1.1742581157840541`, -2.837518507528072}, \
{-1.1742581157840541`, -2.815688827556169}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.125760810882863, -3.0159516481391178`}, \
{-1.125760810882863, -2.993870605717295}}], 
        LineBox[{{-1.125760810882863, -2.993870605717295}, \
{-1.125760810882863, -2.9722666207677366`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.0750347908756233`, -3.1849109666017066`}, \
{-1.0750347908756233`, -3.161769448836232}}], 
        LineBox[{{-1.0750347908756233`, -3.161769448836232}, \
{-1.0750347908756233`, -3.1391513705617813`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.026687762897248, -3.340570739164708}, \
{-1.026687762897248, -3.3200346993578633`}}], 
        LineBox[{{-1.026687762897248, -3.3200346993578633`}, \
{-1.026687762897248, -3.2999119160607924`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.9806356434778151, -3.4971060998997263`}, \
{-0.9806356434778151, -3.475541079865531}}], 
        LineBox[{{-0.9806356434778151, -3.475541079865531}, \
{-0.9806356434778151, -3.454431309717485}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.9288080748978164, -3.6732946373166486`}, \
{-0.9288080748978164, -3.6512842589010117`}}], 
        LineBox[{{-0.9288080748978164, -3.6512842589010117`}, \
{-0.9288080748978164, -3.6297479221324442`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.8758086169295246, -3.8523665070471513`}, \
{-0.8758086169295246, -3.831381295291119}}], 
        LineBox[{{-0.8758086169295246, -3.831381295291119}, \
{-0.8758086169295246, -3.810827426331437}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.8254778772492771, -4.0214234639200805`}, \
{-0.8254778772492771, -4.001549931982177}}], 
        LineBox[{{-0.8254778772492771, -4.001549931982177}, \
{-0.8254778772492771, -3.9820636733257686`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.7775597923865766, -4.184214709978015}, \
{-0.7775597923865766, -4.165503148825294}}], 
        LineBox[{{-0.7775597923865766, -4.165503148825294}, \
{-0.7775597923865766, -4.147135288851474}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.7286714703974044, -4.353601292670439}, \
{-0.7286714703974044, -4.3344836855565845`}}], 
        LineBox[{{-0.7286714703974044, -4.3344836855565845`}, \
{-0.7286714703974044, -4.315724715774761}}]}},
      Antialiasing->False]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
    AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwVxXk81HkfAPDBDHMZc2MSK+vY0pZssrvy+/YybAq56WBpW+JxrCM3KVkJ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     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.990457168951698, -5.238694232194255},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20000], 9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30000], 10.308952660644293`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40000], 10.596634733096073`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60000], 11.002099841204238`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70000], 11.156250521031495`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80000], 11.289781913656018`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90000], 11.407564949312402`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20000], 9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30000], 10.308952660644293`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40000], 10.596634733096073`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60000], 11.002099841204238`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70000], 11.156250521031495`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80000], 11.289781913656018`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90000], 11.407564949312402`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.990457168951698, -0.7286714703974044}, {-5.238694232194255, 
   6.956670316206544}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.8926156752561193`*^9, 
   3.8926157119871216`*^9, 3.8926289949553337`*^9, 3.9023144760150347`*^9, 
   3.902314907158556*^9, 3.9079089393413925`*^9, 3.907908988171488*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"90b3d0e2-de7d-433c-84ed-ae3b0071a48b"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\LH-ESRF-C14 - \
intensity\\\\DataMergedBinned.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.8926156752561193`*^9, 
   3.8926157119871216`*^9, 3.8926289949553337`*^9, 3.9023144760150347`*^9, 
   3.902314907158556*^9, 3.9079089393413925`*^9, 3.9079089897893677`*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"86173bad-c53d-4181-9602-425b5f672301"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Manuscript \
SAXS\\\\SAXS analysis\\\\LH-ESRF-C14 - intensity\\\\Sample playground \
LH-ESRF-C14 NEW SAXS data merged and binned.csv\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.8926156752561193`*^9, 
   3.8926157119871216`*^9, 3.8926289949553337`*^9, 3.9023144760150347`*^9, 
   3.902314907158556*^9, 3.9079089393413925`*^9, 3.9079089899816236`*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"a492d8d8-0c38-45b3-b793-70ca14e2a947"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Plot", " ", "slopes"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotSlopes", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"default", ":", " ", "0.15"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "False", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}]}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<Slopes.pdf\>\""}], "}"}], "]"}], ",", "plotSlopes"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"slope", "[", 
    RowBox[{"datamerged", ",", "0.15"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", " ", "slopes", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", 
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS slopes.csv\>\""}]}], "\[IndentingNewLine]", "}"}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "exportlist"}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   RowBox[{"NotebookFileName", "[", "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.852797516969694*^9, {3.852797632109549*^9, 3.852797683131383*^9}, {
   3.852797796480151*^9, 3.852797853718195*^9}, {3.8527978838837643`*^9, 
   3.852797901227326*^9}, {3.852797980320817*^9, 3.852798038102087*^9}, 
   3.852798223135673*^9, {3.852798406664549*^9, 3.852798409306513*^9}, {
   3.852798512004775*^9, 3.852798555547234*^9}, {3.85279858828354*^9, 
   3.852798831366269*^9}, {3.852798896028565*^9, 3.852799007753936*^9}, {
   3.852799080350028*^9, 3.852799084748775*^9}, {3.8527992586158037`*^9, 
   3.8527992606884203`*^9}, {3.852801934781908*^9, 3.85280197103442*^9}, {
   3.852802103164875*^9, 3.852802118419861*^9}, {3.852862635200562*^9, 
   3.8528626398081703`*^9}, {3.85286268207966*^9, 3.85286275183375*^9}, {
   3.852862799533414*^9, 3.852862876114451*^9}, {3.8528629338179607`*^9, 
   3.852862985846582*^9}, {3.852863040437448*^9, 3.852863051004711*^9}, {
   3.852868510428824*^9, 3.852868602768145*^9}, {3.852868644287572*^9, 
   3.85286868020261*^9}, {3.852868718724351*^9, 3.85286873785894*^9}, {
   3.852868770378528*^9, 3.8528689132597523`*^9}, {3.852868965432905*^9, 
   3.852868981650947*^9}, 3.852870677134739*^9, {3.8528710993603067`*^9, 
   3.852871145669981*^9}, {3.8528716178560038`*^9, 3.852871618411791*^9}, {
   3.852874052533587*^9, 3.852874070324737*^9}, {3.8533820192129173`*^9, 
   3.853382032526078*^9}, {3.853403584226432*^9, 3.853403584753387*^9}, {
   3.8534051467395353`*^9, 3.853405196243081*^9}, {3.853405235261485*^9, 
   3.8534052353804817`*^9}, {3.853405414194544*^9, 3.85340541704944*^9}, {
   3.854423706814918*^9, 3.854423713174549*^9}, {3.8601401065322495`*^9, 
   3.8601401162752795`*^9}, {3.8617652315248656`*^9, 3.861765245785426*^9}, {
   3.861765486245756*^9, 3.861765500810083*^9}, {3.8617668960181065`*^9, 
   3.861766896503375*^9}, {3.861766959391518*^9, 3.861766970643777*^9}, {
   3.861768170754223*^9, 3.861768171551543*^9}, {3.861768267366991*^9, 
   3.8617682678668547`*^9}, 3.861940907625001*^9, {3.861941874731223*^9, 
   3.8619418752572*^9}, {3.863686273326891*^9, 3.86368627384243*^9}, 
   3.863687238834276*^9, {3.8895154361670246`*^9, 3.889515452084921*^9}, {
   3.889672427830373*^9, 3.8896724458079796`*^9}, {3.8896763888939342`*^9, 
   3.8896765605915513`*^9}, 3.889676629643072*^9, {3.88967679120571*^9, 
   3.88967681543388*^9}, {3.889676858823769*^9, 3.889676888283419*^9}, {
   3.8926156862748423`*^9, 3.8926156864647264`*^9}},
 CellLabel->
  "In[2024]:=",ExpressionUUID->"8edd1d77-e6da-4feb-ad70-9ef9a39ee410"],

Cell[BoxData[
 GraphicsBox[{{{
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-5.6554248936175195`, -1.3754752798292404`}, \
{-5.6554248936175195`, -1.0598095276965294`}}], 
         LineBox[{{-5.6554248936175195`, -1.0598095276965294`}, \
{-5.6554248936175195`, -0.7441437755638183}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-5.505650557368423, -1.6058265850271665`}, \
{-5.505650557368423, -1.299153679788789}}], 
         LineBox[{{-5.505650557368423, -1.299153679788789}, \
{-5.505650557368423, -0.9924807745504116}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-5.352012198649872, -1.8664192256781258`}, \
{-5.352012198649872, -1.5487656000261758`}}], 
         LineBox[{{-5.352012198649872, -1.5487656000261758`}, \
{-5.352012198649872, -1.2311119743742258`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-5.197327949963066, -1.9160413309640592`}, \
{-5.197327949963066, -1.6221727152612109`}}], 
         LineBox[{{-5.197327949963066, -1.6221727152612109`}, \
{-5.197327949963066, -1.3283040995583626`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-5.046182498246482, -1.9443899812655037`}, \
{-5.046182498246482, -1.646337564940634}}], 
         LineBox[{{-5.046182498246482, -1.646337564940634}, \
{-5.046182498246482, -1.3482851486157643`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.894444132978499, -2.054729383000484}, \
{-4.894444132978499, -1.7673180501957881`}}], 
         LineBox[{{-4.894444132978499, -1.7673180501957881`}, \
{-4.894444132978499, -1.4799067173910923`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.745125399370905, -2.0436838539320887`}, \
{-4.745125399370905, -1.7790030360493436`}}], 
         LineBox[{{-4.745125399370905, -1.7790030360493436`}, \
{-4.745125399370905, -1.5143222181665987`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.596628633102665, -2.155055401276338}, \
{-4.596628633102665, -1.9018395732059943`}}], 
         LineBox[{{-4.596628633102665, -1.9018395732059943`}, \
{-4.596628633102665, -1.6486237451356507`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.447741719114617, -2.141283295074858}, \
{-4.447741719114617, -1.9072672831704347`}}], 
         LineBox[{{-4.447741719114617, -1.9072672831704347`}, \
{-4.447741719114617, -1.6732512712660113`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.298711959937622, -2.1741403061228324`}, \
{-4.298711959937622, -1.956182801462741}}], 
         LineBox[{{-4.298711959937622, -1.956182801462741}, \
{-4.298711959937622, -1.7382252968026495`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.149632905511913, -2.2157632698654677`}, \
{-4.149632905511913, -2.0014304169941814`}}], 
         LineBox[{{-4.149632905511913, -2.0014304169941814`}, \
{-4.149632905511913, -1.787097564122895}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.001278268975371, -2.180179830632701}, \
{-4.001278268975371, -1.9797092707882549`}}], 
         LineBox[{{-4.001278268975371, -1.9797092707882549`}, \
{-4.001278268975371, -1.7792387109438086`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.8508575458258987`, -2.3621772224343935`}, \
{-3.8508575458258987`, -2.1744414390160456`}}], 
         LineBox[{{-3.8508575458258987`, -2.1744414390160456`}, \
{-3.8508575458258987`, -1.9867056555976979`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.6998351226863213`, -2.21519821644171}, \
{-3.6998351226863213`, -2.03529139387336}}], 
         LineBox[{{-3.6998351226863213`, -2.03529139387336}, \
{-3.6998351226863213`, -1.8553845713050103`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.550260154845919, -2.2882721832855677`}, \
{-3.550260154845919, -2.1232882907193176`}}], 
         LineBox[{{-3.550260154845919, -2.1232882907193176`}, \
{-3.550260154845919, -1.9583043981530677`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.3997502222704012`, -2.2596424372692936`}, \
{-3.3997502222704012`, -2.1108374517938837`}}], 
         LineBox[{{-3.3997502222704012`, -2.1108374517938837`}, \
{-3.3997502222704012`, -1.9620324663184738`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.2492191603155653`, -2.262247354252459}, \
{-3.2492191603155653`, -2.120548060098231}}], 
         LineBox[{{-3.2492191603155653`, -2.120548060098231}, \
{-3.2492191603155653`, -1.9788487659440033`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.099363949694378, -2.325682989323952}, \
{-3.099363949694378, -2.1912112272257005`}}], 
         LineBox[{{-3.099363949694378, -2.1912112272257005`}, \
{-3.099363949694378, -2.056739465127449}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.9723318619592627`, -2.3447234080641337`}, \
{-2.9723318619592627`, -2.1198491065643985`}}], 
         LineBox[{{-2.9723318619592627`, -2.1198491065643985`}, \
{-2.9723318619592627`, -1.8949748050646635`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.8161289018458944`, -2.4254477492472883`}, \
{-2.8161289018458944`, -2.1235798621853275`}}], 
         LineBox[{{-2.8161289018458944`, -2.1235798621853275`}, \
{-2.8161289018458944`, -1.8217119751233666`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.637122953927779, -2.8413253632452493`}, \
{-2.637122953927779, -2.278547275957496}}], 
         LineBox[{{-2.637122953927779, -2.278547275957496}, \
{-2.637122953927779, -1.7157691886697428`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.4883394437723703`, -2.8224766777422747`}, \
{-2.4883394437723703`, -2.2945785421813194`}}], 
         LineBox[{{-2.4883394437723703`, -2.2945785421813194`}, \
{-2.4883394437723703`, -1.766680406620364}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.3426491274116255`, -2.8819377562355633`}, \
{-2.3426491274116255`, -2.3841664101003133`}}], 
         LineBox[{{-2.3426491274116255`, -2.3841664101003133`}, \
{-2.3426491274116255`, -1.8863950639650633`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.1952323671440643`, -2.8970664017320726`}, \
{-2.1952323671440643`, -2.4353568974949273`}}], 
         LineBox[{{-2.1952323671440643`, -2.4353568974949273`}, \
{-2.1952323671440643`, -1.973647393257782}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.048114358050804, -2.968529373545217}, \
{-2.048114358050804, -2.514206950968894}}], 
         LineBox[{{-2.048114358050804, -2.514206950968894}, \
{-2.048114358050804, -2.059884528392571}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.9047213128625353`, -3.0022765477363382`}, \
{-1.9047213128625353`, -2.576373376847949}}], 
         LineBox[{{-1.9047213128625353`, -2.576373376847949}, \
{-1.9047213128625353`, -2.15047020595956}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.7572185227137695`, -3.094837271329944}, \
{-1.7572185227137695`, -2.694912787804791}}], 
         LineBox[{{-1.7572185227137695`, -2.694912787804791}, \
{-1.7572185227137695`, -2.2949883042796384`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.6053998639759, -3.1963113633507874`}, \
{-1.6053998639759, -2.815233406102849}}], 
         LineBox[{{-1.6053998639759, -2.815233406102849}, {-1.6053998639759, \
-2.43415544885491}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.4536487775630647`, -3.319806547313522}, \
{-1.4536487775630647`, -2.9498566221552425`}}], 
         LineBox[{{-1.4536487775630647`, -2.9498566221552425`}, \
{-1.4536487775630647`, -2.579906696996963}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.3021571254789979`, -3.4374715265753477`}, \
{-1.3021571254789979`, -3.0820720918970834`}}], 
         LineBox[{{-1.3021571254789979`, -3.0820720918970834`}, \
{-1.3021571254789979`, -2.726672657218819}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.1509597708634107`, -3.575354502019425}, \
{-1.1509597708634107`, -3.229140593642689}}], 
         LineBox[{{-1.1509597708634107`, -3.229140593642689}, \
{-1.1509597708634107`, -2.8829266852659527`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.0007923805337786`, -3.6838381654034302`}, \
{-1.0007923805337786`, -3.352874895418735}}], 
         LineBox[{{-1.0007923805337786`, -3.352874895418735}, \
{-1.0007923805337786`, -3.02191162543404}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-0.8504177096512346, -3.7163191294527014`}, \
{-0.8504177096512346, -3.4036106316122847`}}], 
         LineBox[{{-0.8504177096512346, -3.4036106316122847`}, \
{-0.8504177096512346, -3.090902133771868}}]}},
       Antialiasing->False]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.6554248936175195`, -0.7441437755638183}, 
            Offset[{3, 
             0}, {-5.6554248936175195`, -0.7441437755638183}]}, \
{{-5.6554248936175195`, -0.7441437755638183}, 
            Offset[{-3, 
             0}, {-5.6554248936175195`, -0.7441437755638183}]}, \
{{-5.6554248936175195`, -1.3754752798292404`}, 
            Offset[{3, 
             0}, {-5.6554248936175195`, -1.3754752798292404`}]}, \
{{-5.6554248936175195`, -1.3754752798292404`}, 
            Offset[{-3, 
             0}, {-5.6554248936175195`, -1.3754752798292404`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.505650557368423, -0.9924807745504116}, 
            Offset[{3, 
             0}, {-5.505650557368423, -0.9924807745504116}]}, \
{{-5.505650557368423, -0.9924807745504116}, 
            Offset[{-3, 
             0}, {-5.505650557368423, -0.9924807745504116}]}, \
{{-5.505650557368423, -1.6058265850271665`}, 
            Offset[{3, 
             0}, {-5.505650557368423, -1.6058265850271665`}]}, \
{{-5.505650557368423, -1.6058265850271665`}, 
            Offset[{-3, 
             0}, {-5.505650557368423, -1.6058265850271665`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.352012198649872, -1.2311119743742258`}, 
            Offset[{3, 
             0}, {-5.352012198649872, -1.2311119743742258`}]}, \
{{-5.352012198649872, -1.2311119743742258`}, 
            Offset[{-3, 
             0}, {-5.352012198649872, -1.2311119743742258`}]}, \
{{-5.352012198649872, -1.8664192256781258`}, 
            Offset[{3, 
             0}, {-5.352012198649872, -1.8664192256781258`}]}, \
{{-5.352012198649872, -1.8664192256781258`}, 
            Offset[{-3, 
             0}, {-5.352012198649872, -1.8664192256781258`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.197327949963066, -1.3283040995583626`}, 
            Offset[{3, 
             0}, {-5.197327949963066, -1.3283040995583626`}]}, \
{{-5.197327949963066, -1.3283040995583626`}, 
            Offset[{-3, 
             0}, {-5.197327949963066, -1.3283040995583626`}]}, \
{{-5.197327949963066, -1.9160413309640592`}, 
            Offset[{3, 
             0}, {-5.197327949963066, -1.9160413309640592`}]}, \
{{-5.197327949963066, -1.9160413309640592`}, 
            Offset[{-3, 
             0}, {-5.197327949963066, -1.9160413309640592`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.046182498246482, -1.3482851486157643`}, 
            Offset[{3, 
             0}, {-5.046182498246482, -1.3482851486157643`}]}, \
{{-5.046182498246482, -1.3482851486157643`}, 
            Offset[{-3, 
             0}, {-5.046182498246482, -1.3482851486157643`}]}, \
{{-5.046182498246482, -1.9443899812655037`}, 
            Offset[{3, 
             0}, {-5.046182498246482, -1.9443899812655037`}]}, \
{{-5.046182498246482, -1.9443899812655037`}, 
            Offset[{-3, 
             0}, {-5.046182498246482, -1.9443899812655037`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.894444132978499, -1.4799067173910923`}, 
            Offset[{3, 
             0}, {-4.894444132978499, -1.4799067173910923`}]}, \
{{-4.894444132978499, -1.4799067173910923`}, 
            Offset[{-3, 
             0}, {-4.894444132978499, -1.4799067173910923`}]}, \
{{-4.894444132978499, -2.054729383000484}, 
            Offset[{3, 
             0}, {-4.894444132978499, -2.054729383000484}]}, \
{{-4.894444132978499, -2.054729383000484}, 
            Offset[{-3, 0}, {-4.894444132978499, -2.054729383000484}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.745125399370905, -1.5143222181665987`}, 
            Offset[{3, 
             0}, {-4.745125399370905, -1.5143222181665987`}]}, \
{{-4.745125399370905, -1.5143222181665987`}, 
            Offset[{-3, 
             0}, {-4.745125399370905, -1.5143222181665987`}]}, \
{{-4.745125399370905, -2.0436838539320887`}, 
            Offset[{3, 
             0}, {-4.745125399370905, -2.0436838539320887`}]}, \
{{-4.745125399370905, -2.0436838539320887`}, 
            Offset[{-3, 
             0}, {-4.745125399370905, -2.0436838539320887`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.596628633102665, -1.6486237451356507`}, 
            Offset[{3, 
             0}, {-4.596628633102665, -1.6486237451356507`}]}, \
{{-4.596628633102665, -1.6486237451356507`}, 
            Offset[{-3, 
             0}, {-4.596628633102665, -1.6486237451356507`}]}, \
{{-4.596628633102665, -2.155055401276338}, 
            Offset[{3, 
             0}, {-4.596628633102665, -2.155055401276338}]}, \
{{-4.596628633102665, -2.155055401276338}, 
            Offset[{-3, 0}, {-4.596628633102665, -2.155055401276338}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.447741719114617, -1.6732512712660113`}, 
            Offset[{3, 
             0}, {-4.447741719114617, -1.6732512712660113`}]}, \
{{-4.447741719114617, -1.6732512712660113`}, 
            Offset[{-3, 
             0}, {-4.447741719114617, -1.6732512712660113`}]}, \
{{-4.447741719114617, -2.141283295074858}, 
            Offset[{3, 
             0}, {-4.447741719114617, -2.141283295074858}]}, \
{{-4.447741719114617, -2.141283295074858}, 
            Offset[{-3, 0}, {-4.447741719114617, -2.141283295074858}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.298711959937622, -1.7382252968026495`}, 
            Offset[{3, 
             0}, {-4.298711959937622, -1.7382252968026495`}]}, \
{{-4.298711959937622, -1.7382252968026495`}, 
            Offset[{-3, 
             0}, {-4.298711959937622, -1.7382252968026495`}]}, \
{{-4.298711959937622, -2.1741403061228324`}, 
            Offset[{3, 
             0}, {-4.298711959937622, -2.1741403061228324`}]}, \
{{-4.298711959937622, -2.1741403061228324`}, 
            Offset[{-3, 
             0}, {-4.298711959937622, -2.1741403061228324`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.149632905511913, -1.787097564122895}, 
            Offset[{3, 
             0}, {-4.149632905511913, -1.787097564122895}]}, \
{{-4.149632905511913, -1.787097564122895}, 
            Offset[{-3, 
             0}, {-4.149632905511913, -1.787097564122895}]}, \
{{-4.149632905511913, -2.2157632698654677`}, 
            Offset[{3, 
             0}, {-4.149632905511913, -2.2157632698654677`}]}, \
{{-4.149632905511913, -2.2157632698654677`}, 
            Offset[{-3, 
             0}, {-4.149632905511913, -2.2157632698654677`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.001278268975371, -1.7792387109438086`}, 
            Offset[{3, 
             0}, {-4.001278268975371, -1.7792387109438086`}]}, \
{{-4.001278268975371, -1.7792387109438086`}, 
            Offset[{-3, 
             0}, {-4.001278268975371, -1.7792387109438086`}]}, \
{{-4.001278268975371, -2.180179830632701}, 
            Offset[{3, 
             0}, {-4.001278268975371, -2.180179830632701}]}, \
{{-4.001278268975371, -2.180179830632701}, 
            Offset[{-3, 0}, {-4.001278268975371, -2.180179830632701}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.8508575458258987`, -1.9867056555976979`}, 
            Offset[{3, 
             0}, {-3.8508575458258987`, -1.9867056555976979`}]}, \
{{-3.8508575458258987`, -1.9867056555976979`}, 
            Offset[{-3, 
             0}, {-3.8508575458258987`, -1.9867056555976979`}]}, \
{{-3.8508575458258987`, -2.3621772224343935`}, 
            Offset[{3, 
             0}, {-3.8508575458258987`, -2.3621772224343935`}]}, \
{{-3.8508575458258987`, -2.3621772224343935`}, 
            Offset[{-3, 
             0}, {-3.8508575458258987`, -2.3621772224343935`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.6998351226863213`, -1.8553845713050103`}, 
            Offset[{3, 
             0}, {-3.6998351226863213`, -1.8553845713050103`}]}, \
{{-3.6998351226863213`, -1.8553845713050103`}, 
            Offset[{-3, 
             0}, {-3.6998351226863213`, -1.8553845713050103`}]}, \
{{-3.6998351226863213`, -2.21519821644171}, 
            Offset[{3, 
             0}, {-3.6998351226863213`, -2.21519821644171}]}, \
{{-3.6998351226863213`, -2.21519821644171}, 
            Offset[{-3, 0}, {-3.6998351226863213`, -2.21519821644171}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.550260154845919, -1.9583043981530677`}, 
            Offset[{3, 
             0}, {-3.550260154845919, -1.9583043981530677`}]}, \
{{-3.550260154845919, -1.9583043981530677`}, 
            Offset[{-3, 
             0}, {-3.550260154845919, -1.9583043981530677`}]}, \
{{-3.550260154845919, -2.2882721832855677`}, 
            Offset[{3, 
             0}, {-3.550260154845919, -2.2882721832855677`}]}, \
{{-3.550260154845919, -2.2882721832855677`}, 
            Offset[{-3, 
             0}, {-3.550260154845919, -2.2882721832855677`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.3997502222704012`, -1.9620324663184738`}, 
            Offset[{3, 
             0}, {-3.3997502222704012`, -1.9620324663184738`}]}, \
{{-3.3997502222704012`, -1.9620324663184738`}, 
            Offset[{-3, 
             0}, {-3.3997502222704012`, -1.9620324663184738`}]}, \
{{-3.3997502222704012`, -2.2596424372692936`}, 
            Offset[{3, 
             0}, {-3.3997502222704012`, -2.2596424372692936`}]}, \
{{-3.3997502222704012`, -2.2596424372692936`}, 
            Offset[{-3, 
             0}, {-3.3997502222704012`, -2.2596424372692936`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.2492191603155653`, -1.9788487659440033`}, 
            Offset[{3, 
             0}, {-3.2492191603155653`, -1.9788487659440033`}]}, \
{{-3.2492191603155653`, -1.9788487659440033`}, 
            Offset[{-3, 
             0}, {-3.2492191603155653`, -1.9788487659440033`}]}, \
{{-3.2492191603155653`, -2.262247354252459}, 
            Offset[{3, 
             0}, {-3.2492191603155653`, -2.262247354252459}]}, \
{{-3.2492191603155653`, -2.262247354252459}, 
            Offset[{-3, 
             0}, {-3.2492191603155653`, -2.262247354252459}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.099363949694378, -2.056739465127449}, 
            Offset[{3, 
             0}, {-3.099363949694378, -2.056739465127449}]}, \
{{-3.099363949694378, -2.056739465127449}, 
            Offset[{-3, 
             0}, {-3.099363949694378, -2.056739465127449}]}, \
{{-3.099363949694378, -2.325682989323952}, 
            Offset[{3, 
             0}, {-3.099363949694378, -2.325682989323952}]}, \
{{-3.099363949694378, -2.325682989323952}, 
            Offset[{-3, 0}, {-3.099363949694378, -2.325682989323952}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.9723318619592627`, -1.8949748050646635`}, 
            Offset[{3, 
             0}, {-2.9723318619592627`, -1.8949748050646635`}]}, \
{{-2.9723318619592627`, -1.8949748050646635`}, 
            Offset[{-3, 
             0}, {-2.9723318619592627`, -1.8949748050646635`}]}, \
{{-2.9723318619592627`, -2.3447234080641337`}, 
            Offset[{3, 
             0}, {-2.9723318619592627`, -2.3447234080641337`}]}, \
{{-2.9723318619592627`, -2.3447234080641337`}, 
            Offset[{-3, 
             0}, {-2.9723318619592627`, -2.3447234080641337`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.8161289018458944`, -1.8217119751233666`}, 
            Offset[{3, 
             0}, {-2.8161289018458944`, -1.8217119751233666`}]}, \
{{-2.8161289018458944`, -1.8217119751233666`}, 
            Offset[{-3, 
             0}, {-2.8161289018458944`, -1.8217119751233666`}]}, \
{{-2.8161289018458944`, -2.4254477492472883`}, 
            Offset[{3, 
             0}, {-2.8161289018458944`, -2.4254477492472883`}]}, \
{{-2.8161289018458944`, -2.4254477492472883`}, 
            Offset[{-3, 
             0}, {-2.8161289018458944`, -2.4254477492472883`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.637122953927779, -1.7157691886697428`}, 
            Offset[{3, 
             0}, {-2.637122953927779, -1.7157691886697428`}]}, \
{{-2.637122953927779, -1.7157691886697428`}, 
            Offset[{-3, 
             0}, {-2.637122953927779, -1.7157691886697428`}]}, \
{{-2.637122953927779, -2.8413253632452493`}, 
            Offset[{3, 
             0}, {-2.637122953927779, -2.8413253632452493`}]}, \
{{-2.637122953927779, -2.8413253632452493`}, 
            Offset[{-3, 
             0}, {-2.637122953927779, -2.8413253632452493`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.4883394437723703`, -1.766680406620364}, 
            Offset[{3, 
             0}, {-2.4883394437723703`, -1.766680406620364}]}, \
{{-2.4883394437723703`, -1.766680406620364}, 
            Offset[{-3, 
             0}, {-2.4883394437723703`, -1.766680406620364}]}, \
{{-2.4883394437723703`, -2.8224766777422747`}, 
            Offset[{3, 
             0}, {-2.4883394437723703`, -2.8224766777422747`}]}, \
{{-2.4883394437723703`, -2.8224766777422747`}, 
            Offset[{-3, 
             0}, {-2.4883394437723703`, -2.8224766777422747`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.3426491274116255`, -1.8863950639650633`}, 
            Offset[{3, 
             0}, {-2.3426491274116255`, -1.8863950639650633`}]}, \
{{-2.3426491274116255`, -1.8863950639650633`}, 
            Offset[{-3, 
             0}, {-2.3426491274116255`, -1.8863950639650633`}]}, \
{{-2.3426491274116255`, -2.8819377562355633`}, 
            Offset[{3, 
             0}, {-2.3426491274116255`, -2.8819377562355633`}]}, \
{{-2.3426491274116255`, -2.8819377562355633`}, 
            Offset[{-3, 
             0}, {-2.3426491274116255`, -2.8819377562355633`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.1952323671440643`, -1.973647393257782}, 
            Offset[{3, 
             0}, {-2.1952323671440643`, -1.973647393257782}]}, \
{{-2.1952323671440643`, -1.973647393257782}, 
            Offset[{-3, 
             0}, {-2.1952323671440643`, -1.973647393257782}]}, \
{{-2.1952323671440643`, -2.8970664017320726`}, 
            Offset[{3, 
             0}, {-2.1952323671440643`, -2.8970664017320726`}]}, \
{{-2.1952323671440643`, -2.8970664017320726`}, 
            Offset[{-3, 
             0}, {-2.1952323671440643`, -2.8970664017320726`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.048114358050804, -2.059884528392571}, 
            Offset[{3, 
             0}, {-2.048114358050804, -2.059884528392571}]}, \
{{-2.048114358050804, -2.059884528392571}, 
            Offset[{-3, 
             0}, {-2.048114358050804, -2.059884528392571}]}, \
{{-2.048114358050804, -2.968529373545217}, 
            Offset[{3, 
             0}, {-2.048114358050804, -2.968529373545217}]}, \
{{-2.048114358050804, -2.968529373545217}, 
            Offset[{-3, 0}, {-2.048114358050804, -2.968529373545217}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.9047213128625353`, -2.15047020595956}, 
            Offset[{3, 
             0}, {-1.9047213128625353`, -2.15047020595956}]}, \
{{-1.9047213128625353`, -2.15047020595956}, 
            Offset[{-3, 
             0}, {-1.9047213128625353`, -2.15047020595956}]}, \
{{-1.9047213128625353`, -3.0022765477363382`}, 
            Offset[{3, 
             0}, {-1.9047213128625353`, -3.0022765477363382`}]}, \
{{-1.9047213128625353`, -3.0022765477363382`}, 
            Offset[{-3, 
             0}, {-1.9047213128625353`, -3.0022765477363382`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.7572185227137695`, -2.2949883042796384`}, 
            Offset[{3, 
             0}, {-1.7572185227137695`, -2.2949883042796384`}]}, \
{{-1.7572185227137695`, -2.2949883042796384`}, 
            Offset[{-3, 
             0}, {-1.7572185227137695`, -2.2949883042796384`}]}, \
{{-1.7572185227137695`, -3.094837271329944}, 
            Offset[{3, 
             0}, {-1.7572185227137695`, -3.094837271329944}]}, \
{{-1.7572185227137695`, -3.094837271329944}, 
            Offset[{-3, 
             0}, {-1.7572185227137695`, -3.094837271329944}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.6053998639759, -2.43415544885491}, 
            Offset[{3, 
             0}, {-1.6053998639759, -2.43415544885491}]}, {{-1.6053998639759, \
-2.43415544885491}, 
            Offset[{-3, 
             0}, {-1.6053998639759, -2.43415544885491}]}, {{-1.6053998639759, \
-3.1963113633507874`}, 
            Offset[{3, 
             0}, {-1.6053998639759, -3.1963113633507874`}]}, \
{{-1.6053998639759, -3.1963113633507874`}, 
            Offset[{-3, 0}, {-1.6053998639759, -3.1963113633507874`}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.4536487775630647`, -2.579906696996963}, 
            Offset[{3, 
             0}, {-1.4536487775630647`, -2.579906696996963}]}, \
{{-1.4536487775630647`, -2.579906696996963}, 
            Offset[{-3, 
             0}, {-1.4536487775630647`, -2.579906696996963}]}, \
{{-1.4536487775630647`, -3.319806547313522}, 
            Offset[{3, 
             0}, {-1.4536487775630647`, -3.319806547313522}]}, \
{{-1.4536487775630647`, -3.319806547313522}, 
            Offset[{-3, 
             0}, {-1.4536487775630647`, -3.319806547313522}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.3021571254789979`, -2.726672657218819}, 
            Offset[{3, 
             0}, {-1.3021571254789979`, -2.726672657218819}]}, \
{{-1.3021571254789979`, -2.726672657218819}, 
            Offset[{-3, 
             0}, {-1.3021571254789979`, -2.726672657218819}]}, \
{{-1.3021571254789979`, -3.4374715265753477`}, 
            Offset[{3, 
             0}, {-1.3021571254789979`, -3.4374715265753477`}]}, \
{{-1.3021571254789979`, -3.4374715265753477`}, 
            Offset[{-3, 
             0}, {-1.3021571254789979`, -3.4374715265753477`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.1509597708634107`, -2.8829266852659527`}, 
            Offset[{3, 
             0}, {-1.1509597708634107`, -2.8829266852659527`}]}, \
{{-1.1509597708634107`, -2.8829266852659527`}, 
            Offset[{-3, 
             0}, {-1.1509597708634107`, -2.8829266852659527`}]}, \
{{-1.1509597708634107`, -3.575354502019425}, 
            Offset[{3, 
             0}, {-1.1509597708634107`, -3.575354502019425}]}, \
{{-1.1509597708634107`, -3.575354502019425}, 
            Offset[{-3, 
             0}, {-1.1509597708634107`, -3.575354502019425}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.0007923805337786`, -3.02191162543404}, 
            Offset[{3, 
             0}, {-1.0007923805337786`, -3.02191162543404}]}, \
{{-1.0007923805337786`, -3.02191162543404}, 
            Offset[{-3, 
             0}, {-1.0007923805337786`, -3.02191162543404}]}, \
{{-1.0007923805337786`, -3.6838381654034302`}, 
            Offset[{3, 
             0}, {-1.0007923805337786`, -3.6838381654034302`}]}, \
{{-1.0007923805337786`, -3.6838381654034302`}, 
            Offset[{-3, 
             0}, {-1.0007923805337786`, -3.6838381654034302`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-0.8504177096512346, -3.090902133771868}, 
            Offset[{3, 
             0}, {-0.8504177096512346, -3.090902133771868}]}, \
{{-0.8504177096512346, -3.090902133771868}, 
            Offset[{-3, 
             0}, {-0.8504177096512346, -3.090902133771868}]}, \
{{-0.8504177096512346, -3.7163191294527014`}, 
            Offset[{3, 
             0}, {-0.8504177096512346, -3.7163191294527014`}]}, \
{{-0.8504177096512346, -3.7163191294527014`}, 
            Offset[{-3, 
             0}, {-0.8504177096512346, -3.7163191294527014`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAPkkMtCefFsD/IdfV+vTwv/xnfELJ
BRbAB7xyXlXJ9L8e+sPidWgVwBCEFHC+x/i/XraOVhDKFMCvKohga/T5vwJ3
/nZKLxTAcYr5DmZX+r+I96wp6ZMTwNeKs0rvRvy/L94WJwL7EsD1EDXjy3b8
v+0hzJ3yYhLAk4gSVe9t/r/AmyLOfMoRwCQq37IqhP6/smxLjOExEcBte1RW
hkz/vwZRTl45mRDAXq1R8+0CAMBixy0XTwEQwB362aDjrP+/NgSnZo7ODsD2
IJ2NQWUBwDs9JChDmQ3AdSG02kZIAMBI18rL7mYMwCT0RJJ+/ADAxsKZPrAy
C8B/A/W+/uIAwEi8eJ1m/gnAw7695uH2AMC/tZJTf8sIwNB/fMCZhwHAYspf
7VXHB8D4MMlyc/UAwPP89ZZuhwbAyT1UcBf9AMCwNFXr0xgFwMcEhf52OgLA
Fcuigh7oA8BPLab+S1sCwA/jYdO+vQLAENK81sUSA8AOCcD81Y8BwEGhpmWc
ewPAsl7Sx4liAMBXTK6IGB0EwATSKw69ef6/tcYepWmcBMB6sm8rkR38v9WM
iW8ujwXALHiMxLev+b8hjI4XmYUGwFMPeDglQve/yl3AbU6ZB8B7+MK1otX0
v/PltGkVqAjAiOvtylRq8r8ODd+pR9UJwDWoB98+A/C/HTm7ErDSCsBWhVwz
nzbrv8i9+DWYOgvAnNwTjQ==
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-6.907755278982122, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{367.456787109375, Automatic},
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.907755278982137, 0.}, {-6., 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], Automatic}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, {3.8926156824974194`*^9, 
   3.8926157165521708`*^9}, 3.8926289998353963`*^9, 3.902314484641642*^9, 
   3.9023149186766763`*^9},
 CellLabel->
  "Out[2024]=",ExpressionUUID->"334c8a94-f1ea-4150-a928-f31808081989"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C14 - \
1.05\\\\Slopes.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, {3.8926156824974194`*^9, 
   3.8926157165521708`*^9}, 3.8926289998353963`*^9, 3.902314484641642*^9, 
   3.9023149197066975`*^9},
 CellLabel->
  "Out[2025]=",ExpressionUUID->"d21c742b-ea50-414f-ae23-ce3a0e94b7f0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.0034984862864694474`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.06", "0.32"},
       "Around"],
      Around[-1.0598095276965294`, 0.3156657521327111]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.004063744022137673`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.30", "0.31"},
       "Around"],
      Around[-1.299153679788789, 0.3066729052383775]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.004738606382434237`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.55", "0.32"},
       "Around"],
      Around[-1.5487656000261758`, 0.31765362565195]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.005531324668202713`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.62", "0.29"},
       "Around"],
      Around[-1.6221727152612109`, 0.2938686157028484]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.006433847850044723`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.65", "0.30"},
       "Around"],
      Around[-1.646337564940634, 0.2980524163248696]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.007488070438661962`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.77", "0.29"},
       "Around"],
      Around[-1.7673180501957881`, 0.2874113328046959]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.008693971718852027`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.78", "0.26"},
       "Around"],
      Around[-1.7790030360493436`, 0.26468081788274495`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.010085781360330545`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.90", "0.25"},
       "Around"],
      Around[-1.9018395732059943`, 0.2532158280703437]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.011704970256750767`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.91", "0.23"},
       "Around"],
      Around[-1.9072672831704347`, 0.23401601190442342`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.013586047120071366`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.96", "0.22"},
       "Around"],
      Around[-1.956182801462741, 0.21795750466009148`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.015770204577577458`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.00", "0.21"},
       "Around"],
      Around[-2.0014304169941814`, 0.2143328528712864]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.018292241533021454`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.98", "0.20"},
       "Around"],
      Around[-1.9797092707882549`, 0.2004705598444464]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.021261495911379928`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.17", "0.19"},
       "Around"],
      Around[-2.1744414390160456`, 0.18773578341834782`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02472760315503566`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.04", "0.18"},
       "Around"],
      Around[-2.03529139387336, 0.17990682256834978`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02871716777200143`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.12", "0.16"},
       "Around"],
      Around[-2.1232882907193176`, 0.16498389256624998`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03338160690107378`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.11", "0.15"},
       "Around"],
      Around[-2.1108374517938837`, 0.14880498547540993`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.038804496095529786`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.12", "0.14"},
       "Around"],
      Around[-2.120548060098231, 0.14169929415422788`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04507786506699304`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.19", "0.13"},
       "Around"],
      Around[-2.1912112272257005`, 0.1344717620982516]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05118381746874888`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.12", "0.22"},
       "Around"],
      Around[-2.1198491065643985`, 0.224874301499735]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05983713035005583`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.12", "0.30"},
       "Around"],
      Around[-2.1235798621853275`, 0.3018678870619609]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07156687484278981`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.6"},
       "Around"],
      Around[-2.278547275957496, 0.5627780872877531]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0830477576097193`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.5"},
       "Around"],
      Around[-2.2945785421813194`, 0.5278981355609552]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0960727917529942`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.4", "0.5"},
       "Around"],
      Around[-2.3841664101003133`, 0.4977713461352499]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1113326884401501`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.4", "0.5"},
       "Around"],
      Around[-2.4353568974949273`, 0.4617095042371454]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1289778805341014`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.5", "0.5"},
       "Around"],
      Around[-2.514206950968894, 0.454322422576323]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.148864123358208`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.6", "0.4"},
       "Around"],
      Around[-2.576373376847949, 0.42590317088838936`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.17252406884397548`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.7", "0.4"},
       "Around"],
      Around[-2.694912787804791, 0.39992448352515264`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2008092424721844`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.8", "0.4"},
       "Around"],
      Around[-2.815233406102849, 0.38107795724793875`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.23371595287707908`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.9", "0.4"},
       "Around"],
      Around[-2.9498566221552425`, 0.3699499251582795]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2719445413748963`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.1", "0.4"},
       "Around"],
      Around[-3.0820720918970834`, 0.35539943467826424`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.316333016423454`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.23", "0.35"},
       "Around"],
      Around[-3.229140593642689, 0.3462139083767363]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3675880561226469`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.35", "0.33"},
       "Around"],
      Around[-3.352874895418735, 0.3309632699846952]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.42723643388934635`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.40", "0.31"},
       "Around"],
      Around[-3.4036106316122847`, 0.31270849784041665`]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, {3.8926156824974194`*^9, 
   3.8926157165521708`*^9}, 3.8926289998353963`*^9, 3.902314484641642*^9, 
   3.902314919727413*^9},
 CellLabel->
  "Out[2026]=",ExpressionUUID->"5cde99bd-f8b6-4346-9d2c-0b142e0a09b8"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C14 - 1.05\\\\Sample \
playground LH-ESRF-C14 NEW SAXS slopes.csv\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, {3.8926156824974194`*^9, 
   3.8926157165521708`*^9}, 3.8926289998353963`*^9, 3.902314484641642*^9, 
   3.9023149198483963`*^9},
 CellLabel->
  "Out[2028]=",ExpressionUUID->"83be1144-8d43-48f3-945c-d4bdffa05024"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C14 - 1.05\\\\Sample \
playground LH-ESRF-C14 NEW.nb\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, {3.8926156824974194`*^9, 
   3.8926157165521708`*^9}, 3.8926289998353963`*^9, 3.902314484641642*^9, 
   3.9023149199138374`*^9},
 CellLabel->
  "Out[2029]=",ExpressionUUID->"62240edf-5a06-45c0-a9cc-fcf7110e1922"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fitting slopes using L + R (thickness + radius)", "Subsubsection",
 CellChangeTimes->{{3.8890831159415197`*^9, 3.889083129907494*^9}, {
  3.8895043397252035`*^9, 
  3.889504346042064*^9}},ExpressionUUID->"c264222d-eedd-4632-bf2a-\
25682c9a5ec9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fitSlopeLRResult", "=", 
  RowBox[{"fitSlopeLR", "[", 
   RowBox[{
   "datamerged", ",", " ", "2.6", ",", " ", "0.5", ",", " ", "6", ",", " ", 
    "0.5"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8890831508560247`*^9, 3.889083186178582*^9}, {
  3.889083221328817*^9, 3.889083280853166*^9}, {3.890210231443339*^9, 
  3.8902102343651667`*^9}},
 CellLabel->
  "In[2037]:=",ExpressionUUID->"245caa09-fb84-4947-ab47-dd7c0b5b4707"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.5176581672702683`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7784548177833933`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.303477681819446`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.07911570264722723`"}]}],
  SequenceForm[
  "\[Mu]l = ", 2.5176581672702683`, " \[Sigma]l = ", 0.7784548177833933, 
   " \[Mu]r = ", 6.303477681819446 " \[Sigma]r = ", -0.07911570264722723],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.902314966446309*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"6c65f957-07fc-4d5a-b1ef-5b2fd837c678"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.55576821073981`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7236065575229571`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.331902782036273`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.305442115787318`"}]}],
  SequenceForm[
  "\[Mu]l = ", 2.55576821073981, " \[Sigma]l = ", 0.7236065575229571, 
   " \[Mu]r = ", 6.331902782036273 " \[Sigma]r = ", -0.305442115787318],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.9023149752121286`*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"6a789c1b-791a-41f7-9dfe-7664968766cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.5943777226992046`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.6631867032485824`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.362010423686482`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.39108452094151847`"}]}],
  SequenceForm[
  "\[Mu]l = ", 2.5943777226992046`, " \[Sigma]l = ", 0.6631867032485824, 
   " \[Mu]r = ", 6.362010423686482 " \[Sigma]r = ", -0.39108452094151847`],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.902314981305669*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"39a320d9-bc86-4903-921f-41e58f9e4741"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.6372875771846305`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.6015358334936135`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.415168924649113`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.4376453130915388`"}]}],
  SequenceForm[
  "\[Mu]l = ", 2.6372875771846305`, " \[Sigma]l = ", 0.6015358334936135, 
   " \[Mu]r = ", 6.415168924649113 " \[Sigma]r = ", -0.4376453130915388],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.902314988693028*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"13223acf-e91f-4883-a7e0-1ef906e8c9e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.734307169633293`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.5816057015595415`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.513151232751739`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.43927928512171593`"}]}],
  SequenceForm[
  "\[Mu]l = ", 2.734307169633293, " \[Sigma]l = ", 0.5816057015595415, 
   " \[Mu]r = ", 6.513151232751739 " \[Sigma]r = ", -0.43927928512171593`],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.9023149921790504`*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"a63e7ea5-71af-47ef-8092-90f6ee78e4ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.804290929114889`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.6469747743882142`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.5513100208309885`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.4462288404240604`"}]}],
  SequenceForm[
  "\[Mu]l = ", 2.804290929114889, " \[Sigma]l = ", 0.6469747743882142, 
   " \[Mu]r = ", 6.5513100208309885` " \[Sigma]r = ", -0.4462288404240604],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.9023149961205816`*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"c5be100e-acfc-4a11-983f-2311ec812770"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.028601087398003`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7567054803132046`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.699840695371418`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.5259712485066357`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.028601087398003, " \[Sigma]l = ", 0.7567054803132046, 
   " \[Mu]r = ", 6.699840695371418 " \[Sigma]r = ", -0.5259712485066357],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.9023149999554243`*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"22245cd2-35a2-4219-aaf4-f64b1fbcc9c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.1091881961639904`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7738961068450605`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.773469610043716`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.5304592245328688`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.1091881961639904`, " \[Sigma]l = ", 0.7738961068450605, 
   " \[Mu]r = ", 6.773469610043716 " \[Sigma]r = ", -0.5304592245328688],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.9023150033969564`*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"38eb3c6b-f478-4790-a187-8a8d8996ab89"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.181522589152488`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7752086894796583`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.8733303559661625`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.5718649786720826`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.181522589152488, " \[Sigma]l = ", 0.7752086894796583, 
   " \[Mu]r = ", 6.8733303559661625` " \[Sigma]r = ", -0.5718649786720826],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.90231500818884*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"8a2e65b2-277c-4174-b994-95c2ee0ab0ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.1951347390419063`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7916586800017924`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.88824120795646`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.5746604377520205`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.1951347390419063`, " \[Sigma]l = ", 0.7916586800017924, 
   " \[Mu]r = ", 6.88824120795646 " \[Sigma]r = ", -0.5746604377520205],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.9023150119623375`*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"8d43009f-da53-44a3-bdac-2bea84ba3cf2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.1760219367902485`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7848351936632545`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.895923118022443`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.5751225435067447`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.1760219367902485`, " \[Sigma]l = ", 0.7848351936632545, 
   " \[Mu]r = ", 6.895923118022443 " \[Sigma]r = ", -0.5751225435067447],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.902315016376924*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"f9643f74-edbe-446a-a877-dfbf5f894748"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.1332954903869354`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7696279186869747`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.966458879523323`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.5955020635598942`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.1332954903869354`, " \[Sigma]l = ", 0.7696279186869747, 
   " \[Mu]r = ", 6.966458879523323 " \[Sigma]r = ", -0.5955020635598942],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.9023150191968985`*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"adf5ea44-b058-4411-99f6-34f78d5e661c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.1319397645316425`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7693026253861747`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"7.0253909987211856`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.6136355615127838`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.1319397645316425`, " \[Sigma]l = ", 0.7693026253861747, 
   " \[Mu]r = ", 7.0253909987211856` " \[Sigma]r = ", -0.6136355615127838],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.902315022064172*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"252776fa-3585-4d1a-8313-a57dcdd2e2f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.1369113441524785`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7712234056655458`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"7.041716592830159`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.6180426566456929`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.1369113441524785`, " \[Sigma]l = ", 0.7712234056655458, 
   " \[Mu]r = ", 7.041716592830159 " \[Sigma]r = ", -0.6180426566456929],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.90231502499561*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"8df7d401-ecf7-47be-bf19-58d62fd32de8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.137353779270999`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7713795793355601`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"7.043934388329827`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.6185467345349093`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.137353779270999, " \[Sigma]l = ", 0.7713795793355601, 
   " \[Mu]r = ", 7.043934388329827 " \[Sigma]r = ", -0.6185467345349093],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.9023150278810167`*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"359e85a8-9c3d-4bf5-9161-0a9714b215c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.137289948953522`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.771351905396542`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"7.0441445030640475`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.6185974317666119`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.137289948953522, " \[Sigma]l = ", 0.771351905396542, 
   " \[Mu]r = ", 7.0441445030640475` " \[Sigma]r = ", -0.6185974317666119],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.902315031724238*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"a3505576-9d18-4b5e-8f35-21016550168f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.1372778305825104`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7713473094674683`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"7.0441448528513995`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.6185968658715392`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.1372778305825104`, " \[Sigma]l = ", 0.7713473094674683, 
   " \[Mu]r = ", 7.0441448528513995` " \[Sigma]r = ", -0.6185968658715392],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.9023150343118124`*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"aca0e365-da07-4e98-884c-783cc55e8baa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.137277885256733`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7713472975736176`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"7.044144646705105`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.6185968278315226`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.137277885256733, " \[Sigma]l = ", 0.7713472975736176, 
   " \[Mu]r = ", 7.044144646705105 " \[Sigma]r = ", -0.6185968278315226],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.9023150379518805`*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"a2d17c4c-40d7-486e-b6b8-7a6edf2e117c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.137277904711001`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7713472983196599`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"7.0441445179767594`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.6185967940458001`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.137277904711001, " \[Sigma]l = ", 0.7713472983196599, 
   " \[Mu]r = ", 7.0441445179767594` " \[Sigma]r = ", -0.6185967940458001],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.9023150452066016`*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"97ab3edc-5fb7-420c-abaa-45da250f2cd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.1372779047109876`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7713472983196527`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"7.044144517976685`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.6185967940457802`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.1372779047109876`, " \[Sigma]l = ", 0.7713472983196527, 
   " \[Mu]r = ", 7.044144517976685 " \[Sigma]r = ", -0.6185967940457802],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.9023150800919466`*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"da200728-7b0c-4f1d-93ba-a0d0ea55ce11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.1372779047107033`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7713472983194943`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"7.044144517975467`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", 
   RowBox[{"-", "0.6185967940454572`"}]}],
  SequenceForm[
  "\[Mu]l = ", 3.1372779047107033`, " \[Sigma]l = ", 0.7713472983194943, 
   " \[Mu]r = ", 7.044144517975467 " \[Sigma]r = ", -0.6185967940454572],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8926157352190285`*^9, 3.892629024635787*^9, 
  3.902314509764866*^9, 3.9023151119172845`*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"145f4dbf-4f09-4ead-8383-7abd485454ea"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 2037, 140, 17025713724928210084, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8914172769507356`*^9, 3.891418369238621*^9, 
  3.892615821916746*^9, 3.892629219138664*^9, 3.902314609916444*^9, 
  3.902315154364312*^9},
 CellLabel->
  "During evaluation of \
In[2037]:=",ExpressionUUID->"143d3cdd-8f06-4b24-a74f-3bce7d87fa6f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]l", "\[Rule]", "3.137277904696257`"}], ",", 
   RowBox[{"\[Sigma]l", "\[Rule]", "0.7713472983148935`"}], ",", 
   RowBox[{"\[Mu]r", "\[Rule]", "7.044144517966634`"}], ",", 
   RowBox[{"\[Sigma]r", "\[Rule]", "0.6185967940413435`"}], ",", 
   RowBox[{"\[Mu]lx", "\[Rule]", "31.02415926226182`"}], ",", 
   RowBox[{"\[Sigma]lx", "\[Rule]", "27.973206692032644`"}], ",", 
   RowBox[{"\[Mu]rx", "\[Rule]", "1387.8006610097136`"}], ",", 
   RowBox[{"\[Sigma]rx", "\[Rule]", "947.5562738365171`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8890831915134697`*^9, 3.889083231716405*^9, 
  3.889084522029305*^9, 3.889504478964719*^9, 3.889668839037505*^9, 
  3.8896689977438555`*^9, 3.8902046298151426`*^9, 3.8902062509864902`*^9, 
  3.8902104624878206`*^9, 3.890216989995762*^9, 3.8902173041350584`*^9, 
  3.8902179907784314`*^9, 3.8909820012674875`*^9, 3.8909824058680325`*^9, 
  3.890982955030755*^9, 3.8909840701831517`*^9, 3.8909841450834846`*^9, 
  3.8909843770126934`*^9, 3.8909844264654613`*^9, 3.890984470131813*^9, 
  3.8914172771083*^9, 3.8914183694354115`*^9, 3.892615821949145*^9, 
  3.89262921919547*^9, 3.9023146099603295`*^9, 3.902315154411488*^9},
 CellLabel->
  "Out[2037]=",ExpressionUUID->"2e1988e4-99cd-4de6-9d68-aaf028356c44"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"ColorData", "[", 
    RowBox[{"\"\<SunsetColors\>\"", ",", "\"\<Image\>\""}], "]"}], "*)"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Visualize", " ", "a", " ", "color", " ", "scheme"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotIntensityFitPlatelets", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
          "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
          "]"}], "/.", "fitSlopeLRResult"}]}], "}"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"Optional", ":", " ", 
        RowBox[{
        "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ", 
         "for", " ", "readibility"}], ":", " ", 
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"5", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", 
           RowBox[{"10", "^", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "6"}]}], ",", " ", 
           RowBox[{"10", "^", "2"}]}], "}"}]}], "}"}]}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "third", " ", "color", " ", "not", " ", "currently", " ", "used"}], 
        ",", " ", 
        RowBox[{
        "but", " ", "left", " ", "here", " ", "for", " ", "reference", " ", 
         "as", " ", "it", " ", "has", " ", "a", " ", "pretty", " ", "decent", 
         " ", "contrast", " ", "with", " ", "the", " ", "first", " ", 
         "color"}]}], " ", "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "i", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "datamerged", "]"}]}], "}"}]}], "]"}], 
        ","}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsIntensityFit.pdf\>\""}], "}"}], "]"}], ",", 
     "plotIntensityFitPlatelets"}], "]"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"slope", "[", 
         RowBox[{"datamerged", ",", "0.15"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"slope", "[", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
           "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
           "]"}], "/.", "fitSlopeLRResult"}], "]"}]}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Binned data\>\"", ",", " ", 
         "\"\<Platelets form factor fit\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", " ", "Dashed"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "\"\<\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFit.pdf\>\""}], "}"}], "]"}], ",", 
     "plotPlateletsFit"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plot3Dprobability", " ", "=", " ", 
    RowBox[{"ListPlot3D", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"l", ",", "r", ",", 
            RowBox[{
             RowBox[{"probfunc", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", 
               ",", "l", ",", "r"}], "]"}], "/.", "fitSlopeLRResult"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ScalingFunctions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "None"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", "Automatic"}], 
        "}"}]}], ",", " ", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Length (nm)\>\"", ",", "\"\<Radius (nm)\>\"", ",", 
         "\"\<Probability\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "12"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"LabelStyle", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
          "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"ColorFunction", "->", 
         RowBox[{"(", 
          RowBox[{"ColorData", "[", "9", "]"}], ")"}]}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"BoxStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsFit3Dprobability.pdf\>\""}], "}"}], "]"}], ",", " ", 
     "plot3Dprobability"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plot2Ddensity", " ", "=", " ", 
    RowBox[{"ListDensityPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"l", ",", "r", ",", 
            RowBox[{
             RowBox[{"probfunc", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", 
               ",", "l", ",", "r"}], "]"}], "/.", "fitSlopeLRResult"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ScalingFunctions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "None"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Length (nm)\>\"", ",", "\"\<Radius (nm)\>\""}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ColorFunction", "->", "\"\<SunsetColors\>\""}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"\"\<CherryTones\>\"", ",", " ", 
        RowBox[{"\"\<SunsetColors\>\"", " ", 
         RowBox[{"(", 
          RowBox[{"one", " ", "directionally", " ", 
           RowBox[{"continuous", "/", "best"}]}], ")"}]}], ",", " ", 
        "\"\<LightTemperatureMap\>\"", ",", " ", 
        "\"\<ThermometerColors\>\""}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", " ", "Automatic"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"PlotLegends", "->", " ", 
        RowBox[{"BarLegend", "[", "\"\<SunsetColors\>\"", "]"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "->", "Automatic"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsFit2Ddensity.pdf\>\""}], "}"}], "]"}], ",", 
     "plot2Ddensity"}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotPlateletDistributions", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lengths", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"LogNormalDistribution", "[", 
                RowBox[{"\[Mu]l", ",", "\[Sigma]l"}], "]"}], "/.", 
               "fitSlopeLRResult"}], ",", "lengths"}], "]"}]}]}], "}"}], 
         "\[Transpose]"}], ",", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Probability", " ", "normalized", " ", "by", " ", "the", " ", 
          "maximum", " ", "probability"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"radii", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"LogNormalDistribution", "[", 
                RowBox[{"\[Mu]r", ",", "\[Sigma]r"}], "]"}], "/.", 
               "fitSlopeLRResult"}], ",", "radii"}], "]"}]}]}], "}"}], 
         "\[Transpose]"}]}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "->", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Size (nm)\>\"", ",", "\"\<Normalized probability\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Platelets thickness fit distribution\>\"", ",", " ", 
         "\"\<Platelets radii fit distribution\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", " ", "Dashed"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletFitDistributions.pdf\>\""}], "}"}], "]"}], ",", 
     "plotPlateletDistributions"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.889083294305049*^9, 3.889083315851309*^9}, {
   3.8890833883662243`*^9, 3.8890834456873417`*^9}, {3.889083486103497*^9, 
   3.8890835217014627`*^9}, {3.889083563050894*^9, 3.8890835639046907`*^9}, {
   3.88908424900935*^9, 3.889084266338831*^9}, {3.8895047640723577`*^9, 
   3.8895048132399473`*^9}, {3.889504846884196*^9, 3.8895048547452297`*^9}, {
   3.8895049269182625`*^9, 3.8895050026520877`*^9}, {3.8895050961729617`*^9, 
   3.889505131901743*^9}, {3.8895051665115204`*^9, 3.88950517791572*^9}, {
   3.889514960971097*^9, 3.889515036411804*^9}, {3.8895151686784644`*^9, 
   3.8895152527812395`*^9}, {3.889515322726761*^9, 3.889515322942603*^9}, {
   3.889515414799749*^9, 3.889515415134011*^9}, {3.889515802135846*^9, 
   3.8895158072956295`*^9}, {3.88951762311401*^9, 3.8895176529460897`*^9}, {
   3.8895177805499964`*^9, 3.8895178521346097`*^9}, {3.8895178958654327`*^9, 
   3.889517895992517*^9}, {3.8895179853740325`*^9, 3.8895179941825094`*^9}, {
   3.889518050385213*^9, 3.8895180651462665`*^9}, {3.889518110111107*^9, 
   3.8895181537599416`*^9}, {3.8895181952428894`*^9, 3.889518231543586*^9}, {
   3.8895182640986247`*^9, 3.889518360154647*^9}, {3.889518402957049*^9, 
   3.8895184404208817`*^9}, {3.889518524888457*^9, 3.8895185272255807`*^9}, {
   3.8895889126133003`*^9, 3.889588935610735*^9}, {3.889589038336623*^9, 
   3.889589077704085*^9}, {3.889592078032647*^9, 3.8895920808209195`*^9}, {
   3.889592118364094*^9, 3.8895924083479843`*^9}, {3.8895925522801237`*^9, 
   3.8895925725829153`*^9}, {3.8895927385856147`*^9, 3.889592740371332*^9}, {
   3.8895928489211516`*^9, 3.8895928588784356`*^9}, {3.8895928981345015`*^9, 
   3.889592939760598*^9}, {3.889592994486616*^9, 3.889593006731392*^9}, {
   3.8896690677438173`*^9, 3.8896690861177497`*^9}, {3.8896691662237344`*^9, 
   3.8896691680709915`*^9}, {3.8896692820528316`*^9, 
   3.8896693106620665`*^9}, {3.889669383022016*^9, 3.8896694349828773`*^9}, {
   3.8896699958407335`*^9, 3.8896699966198225`*^9}, {3.8896701115288887`*^9, 
   3.8896701256913085`*^9}, {3.8896701570270524`*^9, 3.889670157394929*^9}, {
   3.8896712449546976`*^9, 3.889671273339734*^9}, {3.8896722465178547`*^9, 
   3.8896723216246796`*^9}, {3.889677150823584*^9, 3.889677160683831*^9}, {
   3.8896771908757315`*^9, 3.889677195202493*^9}, 3.8896773421424313`*^9, {
   3.889677378283571*^9, 3.8896773887669315`*^9}, {3.88967742719445*^9, 
   3.889677430963851*^9}, {3.889677480339917*^9, 3.889677480743126*^9}, {
   3.889677596624218*^9, 3.8896775968970366`*^9}, {3.889680706734044*^9, 
   3.8896807216712313`*^9}, {3.889680801340059*^9, 3.8896808079046683`*^9}, 
   3.8896849744898243`*^9, {3.889685151140499*^9, 3.8896851850751715`*^9}, {
   3.905228734321274*^9, 
   3.9052287535554466`*^9}},ExpressionUUID->"53db37f2-ab19-4a4d-8175-\
4749ca30cef4"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, {}, 
     {GrayLevel[0], PointSize[0.04], Thickness[0.004], LineBox[CompressedData["
1:eJwtlHk01Xkfx62X61ru6m62i3vjmrYpFZk2k6inQTIKRRtNi6R6HtXYslRT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       "]]}}, {
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.01], Thickness[0.005], PointBox[CompressedData["
1:eJwVV3k4lV8Xxb3Xnd3BPBUVIpUUEnpPokghQyMiSUlIGmRMGihREamMFSml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       "]]}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.298317366548025, -13.815510557964243`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500000], -13.122363377404328`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 3]], -12.716898269296165`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250000], -12.429216196844383`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200000], -12.206072645530174`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500000, 3]], -12.02375108873622], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 7]], -11.86960040890896], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125000], -11.736069016284437`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 9]], -11.618285980628055`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50000], -10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 3]], -10.41431317630212], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25000], -10.126631103850338`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20000], -9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50000, 3]], -9.721165995742174], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 7]], -9.567015315914915], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[12500], -9.433483923290392], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 9]], -9.315700887634009], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500000], -13.122363377404328`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 3]], -12.716898269296165`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250000], -12.429216196844383`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200000], -12.206072645530174`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500000, 3]], -12.02375108873622], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 7]], -11.86960040890896], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125000], -11.736069016284437`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 9]], -11.618285980628055`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50000], -10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 3]], -10.41431317630212], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25000], -10.126631103850338`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20000], -9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50000, 3]], -9.721165995742174], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 7]], -9.567015315914915], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[12500], -9.433483923290392], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 9]], -9.315700887634009], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.298317366548036, 0.}, {-13.815510557964274`, 
   4.605170185988092}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8926158229674926`*^9, 
   3.89262922150885*^9, 3.902314611163923*^9, 3.902315155102569*^9},
 CellLabel->
  "Out[2038]=",ExpressionUUID->"e40376de-e47d-404d-b195-9f42d57efcd7"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C14 - \
1.05\\\\PlateletsIntensityFit.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8926158229674926`*^9, 
   3.89262922150885*^9, 3.902314611163923*^9, 3.9023151565146847`*^9},
 CellLabel->
  "Out[2039]=",ExpressionUUID->"c2acf97a-8408-41e9-91f9-abde5da7e92a"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.6554248936175195`, -1.3754752798292404`}, \
{-5.6554248936175195`, -1.0598095276965294`}}], 
          
          LineBox[{{-5.6554248936175195`, -1.0598095276965294`}, \
{-5.6554248936175195`, -0.7441437755638183}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.505650557368423, -1.6058265850271665`}, \
{-5.505650557368423, -1.299153679788789}}], 
          
          LineBox[{{-5.505650557368423, -1.299153679788789}, \
{-5.505650557368423, -0.9924807745504116}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.8664192256781258`}, \
{-5.352012198649872, -1.5487656000261758`}}], 
          
          LineBox[{{-5.352012198649872, -1.5487656000261758`}, \
{-5.352012198649872, -1.2311119743742258`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.9160413309640592`}, \
{-5.197327949963066, -1.6221727152612109`}}], 
          
          LineBox[{{-5.197327949963066, -1.6221727152612109`}, \
{-5.197327949963066, -1.3283040995583626`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9443899812655037`}, \
{-5.046182498246482, -1.646337564940634}}], 
          
          LineBox[{{-5.046182498246482, -1.646337564940634}, \
{-5.046182498246482, -1.3482851486157643`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.054729383000484}, \
{-4.894444132978499, -1.7673180501957881`}}], 
          
          LineBox[{{-4.894444132978499, -1.7673180501957881`}, \
{-4.894444132978499, -1.4799067173910923`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.0436838539320887`}, \
{-4.745125399370905, -1.7790030360493436`}}], 
          
          LineBox[{{-4.745125399370905, -1.7790030360493436`}, \
{-4.745125399370905, -1.5143222181665987`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.155055401276338}, \
{-4.596628633102665, -1.9018395732059943`}}], 
          
          LineBox[{{-4.596628633102665, -1.9018395732059943`}, \
{-4.596628633102665, -1.6486237451356507`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.141283295074858}, \
{-4.447741719114617, -1.9072672831704347`}}], 
          
          LineBox[{{-4.447741719114617, -1.9072672831704347`}, \
{-4.447741719114617, -1.6732512712660113`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.1741403061228324`}, \
{-4.298711959937622, -1.956182801462741}}], 
          
          LineBox[{{-4.298711959937622, -1.956182801462741}, \
{-4.298711959937622, -1.7382252968026495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.2157632698654677`}, \
{-4.149632905511913, -2.0014304169941814`}}], 
          
          LineBox[{{-4.149632905511913, -2.0014304169941814`}, \
{-4.149632905511913, -1.787097564122895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.180179830632701}, \
{-4.001278268975371, -1.9797092707882549`}}], 
          
          LineBox[{{-4.001278268975371, -1.9797092707882549`}, \
{-4.001278268975371, -1.7792387109438086`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.3621772224343935`}, \
{-3.8508575458258987`, -2.1744414390160456`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.1744414390160456`}, \
{-3.8508575458258987`, -1.9867056555976979`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.21519821644171}, \
{-3.6998351226863213`, -2.03529139387336}}], 
          
          LineBox[{{-3.6998351226863213`, -2.03529139387336}, \
{-3.6998351226863213`, -1.8553845713050103`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.2882721832855677`}, \
{-3.550260154845919, -2.1232882907193176`}}], 
          
          LineBox[{{-3.550260154845919, -2.1232882907193176`}, \
{-3.550260154845919, -1.9583043981530677`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2596424372692936`}, \
{-3.3997502222704012`, -2.1108374517938837`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.1108374517938837`}, \
{-3.3997502222704012`, -1.9620324663184738`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.262247354252459}, \
{-3.2492191603155653`, -2.120548060098231}}], 
          
          LineBox[{{-3.2492191603155653`, -2.120548060098231}, \
{-3.2492191603155653`, -1.9788487659440033`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.325682989323952}, \
{-3.099363949694378, -2.1912112272257005`}}], 
          
          LineBox[{{-3.099363949694378, -2.1912112272257005`}, \
{-3.099363949694378, -2.056739465127449}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3447234080641337`}, \
{-2.9723318619592627`, -2.1198491065643985`}}], 
          
          LineBox[{{-2.9723318619592627`, -2.1198491065643985`}, \
{-2.9723318619592627`, -1.8949748050646635`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.4254477492472883`}, \
{-2.8161289018458944`, -2.1235798621853275`}}], 
          
          LineBox[{{-2.8161289018458944`, -2.1235798621853275`}, \
{-2.8161289018458944`, -1.8217119751233666`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.8413253632452493`}, \
{-2.637122953927779, -2.278547275957496}}], 
          
          LineBox[{{-2.637122953927779, -2.278547275957496}, \
{-2.637122953927779, -1.7157691886697428`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.8224766777422747`}, \
{-2.4883394437723703`, -2.2945785421813194`}}], 
          
          LineBox[{{-2.4883394437723703`, -2.2945785421813194`}, \
{-2.4883394437723703`, -1.766680406620364}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.8819377562355633`}, \
{-2.3426491274116255`, -2.3841664101003133`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.3841664101003133`}, \
{-2.3426491274116255`, -1.8863950639650633`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.8970664017320726`}, \
{-2.1952323671440643`, -2.4353568974949273`}}], 
          
          LineBox[{{-2.1952323671440643`, -2.4353568974949273`}, \
{-2.1952323671440643`, -1.973647393257782}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.968529373545217}, \
{-2.048114358050804, -2.514206950968894}}], 
          
          LineBox[{{-2.048114358050804, -2.514206950968894}, \
{-2.048114358050804, -2.059884528392571}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -3.0022765477363382`}, \
{-1.9047213128625353`, -2.576373376847949}}], 
          
          LineBox[{{-1.9047213128625353`, -2.576373376847949}, \
{-1.9047213128625353`, -2.15047020595956}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -3.094837271329944}, \
{-1.7572185227137695`, -2.694912787804791}}], 
          
          LineBox[{{-1.7572185227137695`, -2.694912787804791}, \
{-1.7572185227137695`, -2.2949883042796384`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -3.1963113633507874`}, \
{-1.6053998639759, -2.815233406102849}}], 
          
          LineBox[{{-1.6053998639759, -2.815233406102849}, {-1.6053998639759, \
-2.43415544885491}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.319806547313522}, \
{-1.4536487775630647`, -2.9498566221552425`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.9498566221552425`}, \
{-1.4536487775630647`, -2.579906696996963}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.4374715265753477`}, \
{-1.3021571254789979`, -3.0820720918970834`}}], 
          
          LineBox[{{-1.3021571254789979`, -3.0820720918970834`}, \
{-1.3021571254789979`, -2.726672657218819}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.575354502019425}, \
{-1.1509597708634107`, -3.229140593642689}}], 
          
          LineBox[{{-1.1509597708634107`, -3.229140593642689}, \
{-1.1509597708634107`, -2.8829266852659527`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.0007923805337786`, -3.6838381654034302`}, \
{-1.0007923805337786`, -3.352874895418735}}], 
          
          LineBox[{{-1.0007923805337786`, -3.352874895418735}, \
{-1.0007923805337786`, -3.02191162543404}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-0.8504177096512346, -3.7163191294527014`}, \
{-0.8504177096512346, -3.4036106316122847`}}], 
          
          LineBox[{{-0.8504177096512346, -3.4036106316122847`}, \
{-0.8504177096512346, -3.090902133771868}}]}}}}}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1VXk8Vdv7Pg4OB4d9HOeYRSHRRBGhraRQSqmohCSJupJMhVBJaRRJhky5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         "]]}}, {{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.01], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               DiskBox[{0, 0}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
                 PointSize[0.01], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.272]], CompressedData["
1:eJwBJQLa/SFib1JlAwAAACEAAAABAAAAAgAAAD5JDLQnnxbA/yHX1fr08L/8
Z3xCyQUWwAe8cl5VyfS/HvrD4nVoFcAQhBRwvsf4v162jlYQyhTAryqIYGv0
+b8Cd/52Si8UwHGK+Q5mV/q/iPesKemTE8DXirNK70b8vy/eFicC+xLA9RA1
48t2/L/tIcyd8mISwJOIElXvbf6/wJsiznzKEcAkKt+yKoT+v7JsS4zhMRHA
bXtUVoZM/78GUU5eOZkQwF6tUfPtAgDAYsctF08BEMAd+tmg46z/vzYEp2aO
zg7A9iCdjUFlAcA7PSQoQ5kNwHUhtNpGSADASNfKy+5mDMAk9ESSfvwAwMbC
mT6wMgvAfwP1vv7iAMBIvHidZv4JwMO+vebh9gDAv7WSU3/LCMDQf3zAmYcB
wGLKX+1VxwfA+DDJcnP1AMDz/PWWbocGwMk9VHAX/QDAsDRV69MYBcDHBIX+
djoCwBXLooIe6APATy2m/ktbAsAP42HTvr0CwBDSvNbFEgPADgnA/NWPAcBB
oaZlnHsDwLJe0seJYgDAV0yuiBgdBMAE0isOvXn+v7XGHqVpnATAerJvK5Ed
/L/VjIlvLo8FwCx4jMS3r/m/IYyOF5mFBsBTD3g4JUL3v8pdwG1OmQfAe/jC
taLV9L/z5bRpFagIwIjr7cpUavK/Dg3fqUfVCcA1qAffPgPwvx05uxKw0grA
VoVcM58267/Ivfg1mDoLwKhIE48=
         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         TagBox[
          InsetBox["", {0., 0.}], "InsetString"], CompressedData["
1:eJw1VXk4lN0bHoNhMLxjzAyDiTKI9lJEvSKFElJRiZIk6ivJVghJSqtIsmTL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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-7.2705523451534315`, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-7.2705523451534315`, 
       2.2795592420641055`}, {-4.157373229115222, 0}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.02]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Binned data\"", "\"Platelets form factor fit\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.28196428571428567`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                  